/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import org.richfaces.model.DataVisitResult;
import org.richfaces.model.DataVisitor;
import org.richfaces.model.ExtendedDataModel;
import org.richfaces.model.Range;
import org.richfaces.model.SequenceRange;

public class SequenceDataModel<E>
extends ExtendedDataModel<E> {
    private DataModel<E> wrappedModel;

    public SequenceDataModel(DataModel<E> wrapped) {
        this.wrappedModel = wrapped;
    }

    @Override
    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) {
        SequenceRange seqRange = (SequenceRange)range;
        int rows = seqRange.getRows();
        int rowCount = this.wrappedModel.getRowCount();
        int currentRow = seqRange.getFirstRow();
        if (rows > 0) {
            rows += currentRow;
            if (rowCount >= 0) {
                rows = Math.min(rows, rowCount);
            }
        } else {
            rows = rowCount >= 0 ? rowCount : -1;
        }
        DataVisitResult visitResult = null;
        while (rows < 0 || currentRow < rows) {
            this.wrappedModel.setRowIndex(currentRow);
            if (!this.wrappedModel.isRowAvailable() || DataVisitResult.STOP.equals((Object)(visitResult = visitor.process(context, new Integer(currentRow), argument)))) break;
            ++currentRow;
        }
    }

    @Override
    public Object getRowKey() {
        int index = this.wrappedModel.getRowIndex();
        if (index < 0) {
            return null;
        }
        return new Integer(index);
    }

    @Override
    public void setRowKey(Object key) {
        if (null == key) {
            this.wrappedModel.setRowIndex(-1);
        } else {
            Integer index = (Integer)key;
            this.wrappedModel.setRowIndex(index.intValue());
        }
    }

    public int getRowCount() {
        return this.wrappedModel.getRowCount();
    }

    public E getRowData() {
        return (E)this.wrappedModel.getRowData();
    }

    public int getRowIndex() {
        return this.wrappedModel.getRowIndex();
    }

    public Object getWrappedData() {
        return this.wrappedModel.getWrappedData();
    }

    public boolean isRowAvailable() {
        return this.wrappedModel.isRowAvailable();
    }

    public void setRowIndex(int rowIndex) {
        this.wrappedModel.setRowIndex(rowIndex);
    }

    public void setWrappedData(Object data) {
        this.wrappedModel.setWrappedData(data);
    }

    protected DataModel<E> getWrappedModel() {
        return this.wrappedModel;
    }

    protected void setWrappedModel(DataModel<E> wrappedModel) {
        this.wrappedModel = wrappedModel;
    }
}

