/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.push;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.push.DefaultMessageDataSerializer;
import org.richfaces.push.MessageDataSerializer;
import org.richfaces.push.MessageException;
import org.richfaces.push.Session;
import org.richfaces.push.SessionPreSubscriptionEvent;
import org.richfaces.push.SubscriptionFailureException;
import org.richfaces.push.Topic;
import org.richfaces.push.TopicEvent;
import org.richfaces.push.TopicKey;
import org.richfaces.push.TopicListener;

public abstract class AbstractTopic
implements Topic {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private TopicKey key;
    private volatile MessageDataSerializer serializer;
    private volatile boolean allowSubtopics;
    private List<TopicListener> listeners = new CopyOnWriteArrayList<TopicListener>();

    public AbstractTopic(TopicKey key) {
        this.key = key;
    }

    @Override
    public MessageDataSerializer getMessageDataSerializer() {
        if (this.serializer == null) {
            return DefaultMessageDataSerializer.instance();
        }
        return this.serializer;
    }

    @Override
    public void setMessageDataSerializer(MessageDataSerializer serializer) {
        this.serializer = serializer;
    }

    public boolean isAllowSubtopics() {
        return this.allowSubtopics;
    }

    public void setAllowSubtopics(boolean allowSubtopics) {
        this.allowSubtopics = allowSubtopics;
    }

    @Override
    public TopicKey getKey() {
        return this.key;
    }

    @Override
    public void addTopicListener(TopicListener topicListener) {
        TopicListener listener = topicListener;
        this.listeners.add(listener);
    }

    @Override
    public void removeTopicListener(TopicListener topicListener) {
        this.listeners.remove(topicListener);
    }

    @Override
    public void checkSubscription(TopicKey key, Session session) throws SubscriptionFailureException {
        SessionPreSubscriptionEvent event = new SessionPreSubscriptionEvent(this, key, session);
        for (TopicListener listener : this.listeners) {
            if (!event.isAppropriateListener(listener)) continue;
            try {
                event.invokeListener(listener);
            }
            catch (SubscriptionFailureException e) {
                throw e;
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    private void logError(Exception e) {
        LOGGER.error(MessageFormat.format("Exception invoking listener: {0}", e.getMessage()), e);
    }

    @Override
    public void publishEvent(TopicEvent event) {
        for (TopicListener listener : this.listeners) {
            if (!event.isAppropriateListener(listener)) continue;
            try {
                event.invokeListener(listener);
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    @Override
    public abstract void publish(TopicKey var1, Object var2) throws MessageException;
}

