/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.push;

import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.richfaces.configuration.ConfigurationServiceHelper;
import org.richfaces.configuration.CoreConfiguration;
import org.richfaces.push.PushContext;
import org.richfaces.push.PushContextFactory;
import org.richfaces.push.PushContextImpl;
import org.richfaces.push.PushContextInitializationException;

public class PushContextFactoryImpl
implements PushContextFactory {
    public static final String PUSH_HANDLER_MAPPING_ATTRIBUTE = PushContextFactoryImpl.class.getName();
    public static final String PUSH_CONTEXT_RESOURCE_NAME = "__richfaces_push";
    private static final AtomicReference<PushContext> PUSH_CONTEXT_HOLDER = new AtomicReference();

    private static String getApplicationContextName(FacesContext facesContext) {
        Object contextObject = facesContext.getExternalContext().getContext();
        if (contextObject instanceof ServletContext) {
            return ((ServletContext)contextObject).getContextPath();
        }
        return "/";
    }

    private static String convertToUrl(FacesContext facesContext, String mapping) {
        if (mapping == null) {
            return mapping;
        }
        String url = mapping.replaceAll(Pattern.quote("*"), PUSH_CONTEXT_RESOURCE_NAME);
        if (!url.startsWith("/")) {
            url = '/' + url;
        }
        return PushContextFactoryImpl.getApplicationContextName(facesContext) + url;
    }

    private static PushContext createInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new PushContextInitializationException("FacesContext is not available when trying to initialize PushContext - use startup initialization (web.xml context-param org.richfaces.push.initializeOnStartup = true)");
        }
        String pushHandlerMapping = (String)facesContext.getExternalContext().getApplicationMap().get(PUSH_HANDLER_MAPPING_ATTRIBUTE);
        if (pushHandlerMapping == null) {
            pushHandlerMapping = ConfigurationServiceHelper.getStringConfigurationValue(facesContext, CoreConfiguration.Items.pushHandlerMapping);
            facesContext.getExternalContext().getApplicationMap().put(PUSH_HANDLER_MAPPING_ATTRIBUTE, pushHandlerMapping);
        }
        PushContextImpl pushContext = new PushContextImpl(PushContextFactoryImpl.convertToUrl(facesContext, pushHandlerMapping));
        pushContext.init(facesContext);
        return pushContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PushContext getPushContext() {
        if (PUSH_CONTEXT_HOLDER.get() == null) {
            AtomicReference<PushContext> atomicReference = PUSH_CONTEXT_HOLDER;
            synchronized (atomicReference) {
                if (PUSH_CONTEXT_HOLDER.get() == null) {
                    PushContext pushContext = PushContextFactoryImpl.createInstance();
                    PUSH_CONTEXT_HOLDER.set(pushContext);
                }
            }
        }
        return PUSH_CONTEXT_HOLDER.get();
    }
}

