/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.push;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.push.Session;
import org.richfaces.push.SessionManager;
import org.richfaces.push.SessionQueue;

public class SessionManagerImpl
implements SessionManager {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private ConcurrentMap<String, Session> sessionMap = new MapMaker().makeMap();
    private SessionQueue sessionQueue = new SessionQueue();
    private ExecutorService executorService;

    public SessionManagerImpl(ThreadFactory threadFactory) {
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.executorService.submit(new SessionsExpirationRunnable());
    }

    @Override
    public Session getPushSession(String id) {
        return (Session)this.sessionMap.get(id);
    }

    @Override
    public void destroy() {
        this.executorService.shutdown();
        this.sessionQueue.shutdown();
        for (Session session : this.sessionMap.values()) {
            if (!(session instanceof DestroyableSession)) continue;
            ((DestroyableSession)((Object)session)).destroy();
        }
        this.sessionMap.clear();
    }

    @Override
    public void putPushSession(Session session) throws IllegalStateException {
        Session existingSession = this.sessionMap.putIfAbsent(session.getId(), session);
        if (existingSession != null) {
            throw new IllegalStateException();
        }
        this.sessionQueue.requeue(session, true);
    }

    @Override
    public void requeue(Session session) {
        this.sessionQueue.requeue(session, false);
    }

    private final class SessionsExpirationRunnable
    implements Runnable {
        private SessionsExpirationRunnable() {
        }

        @Override
        public void run() {
            try {
                Session session = SessionManagerImpl.this.sessionQueue.take();
                if (session instanceof DestroyableSession) {
                    ((DestroyableSession)((Object)session)).destroy();
                }
                SessionManagerImpl.this.sessionMap.remove(session.getId());
                SessionManagerImpl.this.executorService.submit(this);
            }
            catch (InterruptedException e) {
                LOGGER.debug(e.getMessage(), e);
            }
        }
    }

    static interface DestroyableSession {
        public void destroy();
    }
}

