/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.push;

import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.richfaces.push.AbstractTopic;
import org.richfaces.push.MessageException;
import org.richfaces.push.Session;
import org.richfaces.push.SessionSubscriptionEvent;
import org.richfaces.push.SessionUnsubscriptionEvent;
import org.richfaces.push.TopicEvent;
import org.richfaces.push.TopicKey;
import org.richfaces.push.TopicsContextImpl;

public class TopicImpl
extends AbstractTopic {
    private ConcurrentMap<TopicKey, TopicContext> sessions = new ConcurrentHashMap<TopicKey, TopicContext>();
    private TopicsContextImpl topicsContext;

    public TopicImpl(TopicKey key, TopicsContextImpl topicsContext) {
        super(key);
        this.topicsContext = topicsContext;
    }

    private TopicContext getTopicContext(TopicKey key) {
        return (TopicContext)this.sessions.get(key);
    }

    private TopicContext getOrCreateTopicContext(TopicKey key) {
        TopicContext freshContext;
        TopicContext result = (TopicContext)this.sessions.get(key);
        if (result == null && (result = this.sessions.putIfAbsent(key, freshContext = new TopicContext(key))) == null) {
            result = freshContext;
        }
        return result;
    }

    @Override
    public void publish(TopicKey key, Object messageData) throws MessageException {
        TopicContext topicContext;
        String serializedData = this.getMessageDataSerializer().serialize(messageData);
        if (serializedData != null && (topicContext = this.getTopicContext(key)) != null) {
            topicContext.addMessage(serializedData);
        }
    }

    @Override
    public void publishEvent(TopicEvent event) {
        super.publishEvent(event);
        if (event instanceof SessionSubscriptionEvent) {
            SessionSubscriptionEvent subscriptionEvent = (SessionSubscriptionEvent)event;
            this.getOrCreateTopicContext(subscriptionEvent.getTopicKey()).addSession(subscriptionEvent.getSession());
        } else if (event instanceof SessionUnsubscriptionEvent) {
            SessionUnsubscriptionEvent unsubscriptionEvent = (SessionUnsubscriptionEvent)event;
            this.getTopicContext(unsubscriptionEvent.getTopicKey()).removeSession(unsubscriptionEvent.getSession());
        }
    }

    private final class TopicContext {
        private final List<Session> sessions = new CopyOnWriteArrayList<Session>();
        private final Queue<String> serializedMessages = new ConcurrentLinkedQueue<String>();
        private final TopicKey key;
        private boolean submittedForPublishing;

        public TopicContext(TopicKey key) {
            this.key = key;
        }

        public void addSession(Session session) {
            this.sessions.add(session);
        }

        public void removeSession(Session session) {
            this.sessions.remove(session);
        }

        public void addMessage(String serializedMessageData) {
            this.serializedMessages.add(serializedMessageData);
            this.submitForPublishing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publishMessages() {
            Iterator itr = this.serializedMessages.iterator();
            while (itr.hasNext()) {
                String message = (String)itr.next();
                for (Session session : this.sessions) {
                    session.push(this.key, message);
                }
                itr.remove();
            }
            TopicContext topicContext = this;
            synchronized (topicContext) {
                this.submittedForPublishing = false;
                if (!this.serializedMessages.isEmpty()) {
                    this.submitForPublishing();
                }
            }
        }

        private synchronized void submitForPublishing() {
            if (!this.submittedForPublishing) {
                this.submittedForPublishing = true;
                TopicImpl.this.topicsContext.getPublisherService().submit(new PublishTask(this));
            }
        }
    }

    private static final class PublishTask
    implements Runnable {
        private final TopicContext topicContext;

        public PublishTask(TopicContext topicContext) {
            this.topicContext = topicContext;
        }

        @Override
        public void run() {
            this.topicContext.publishMessages();
        }
    }
}

