/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.javascript.JSFunctionDefinition;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.ui.common.ComponentAttribute;

public final class RenderKitUtils {
    static final String BEHAVIOR_SOURCE_ID = "javax.faces.source";
    static final String BEHAVIOR_EVENT_NAME = "javax.faces.behavior.event";
    private static final String XHTML_ATTRIBUTE_PREFIX = "xml:";
    private static final String XHTML_CONTENT_TYPE = "application/xhtml+xml";
    private static final String ATTRIBUTES_THAT_ARE_SET = UIComponentBase.class.getName() + ".attributesThatAreSet";
    private static final String[] BOOLEAN_ATTRIBUTE_NAMES = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noshade", "nowrap", "readonly", "selected"};
    private static final String[] URI_ATTRIBUTE_NAMES = new String[]{"action", "background", "cite", "classid", "codebase", "data", "href", "longdesc", "profile", "src", "usemap"};
    private static final String[] XHTML_ATTRIBUTE_NAMES = new String[]{"lang"};
    private static final String DISABLED_ATTRIBUTE_NAME = "disabled";

    private RenderKitUtils() {
    }

    public static String[] asArray(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> componentType = object.getClass().getComponentType();
        if (String.class.equals(componentType)) {
            return (String[])object;
        }
        if (componentType != null) {
            Object[] objects = (Object[])object;
            String[] result = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                Object o = objects[i];
                if (o == null) continue;
                result[i] = o.toString();
            }
            return result;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            String[] result = new String[collection.size()];
            Iterator iterator = collection.iterator();
            for (int i = 0; i < result.length; ++i) {
                Object next = iterator.next();
                if (next == null) continue;
                result[i] = next.toString();
            }
            return result;
        }
        String string = object.toString().trim();
        String[] split = string.split("\\s*,\\s*");
        return split;
    }

    private static Map<String, List<ClientBehavior>> getClientBehaviorsMap(UIComponent component) {
        Map result;
        if (component instanceof ClientBehaviorHolder) {
            ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)component;
            result = clientBehaviorHolder.getClientBehaviors();
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    static boolean isDisabled(UIComponent component) {
        Object disabledAttributeValue = component.getAttributes().get(DISABLED_ATTRIBUTE_NAME);
        if (disabledAttributeValue == null) {
            return false;
        }
        if (disabledAttributeValue instanceof Boolean) {
            return Boolean.TRUE.equals(disabledAttributeValue);
        }
        return Boolean.valueOf(disabledAttributeValue.toString());
    }

    static String escape(String s) {
        int end;
        StringBuilder sb = new StringBuilder(s.length());
        int start = 0;
        while ((end = s.indexOf(39, start)) >= 0) {
            sb.append(s, start, end);
            sb.append("\\'");
            start = end + 1;
        }
        sb.append(s, start, s.length());
        return sb.toString();
    }

    static boolean chain(StringBuilder sb, Object object, boolean isChained) {
        String objectString;
        if (object != null && (objectString = object.toString().trim()).length() != 0) {
            boolean localIsChained;
            if (!isChained && sb.length() != 0) {
                String previousHandlerString = sb.toString();
                sb.setLength(0);
                sb.append("'");
                sb.append(RenderKitUtils.escape(previousHandlerString));
                sb.append("'");
                localIsChained = true;
            } else {
                localIsChained = isChained;
            }
            if (localIsChained) {
                sb.append(",'");
                sb.append(RenderKitUtils.escape(objectString));
                sb.append("'");
                return true;
            }
            sb.append(objectString);
            return false;
        }
        return isChained;
    }

    private static Object createBehaviorsChain(Object inlineHandlerValue, ClientBehaviorContext behaviorContext, List<ClientBehavior> behaviors) {
        boolean isChained = false;
        StringBuilder result = new StringBuilder();
        isChained = RenderKitUtils.chain(result, inlineHandlerValue, isChained);
        for (ClientBehavior behavior : behaviors) {
            isChained = RenderKitUtils.chain(result, behavior.getScript(behaviorContext), isChained);
            if (!behavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) continue;
            break;
        }
        if (result.length() == 0) {
            return null;
        }
        if (isChained) {
            result.insert(0, "return jsf.util.chain(this, event, ");
            result.append(")");
        }
        return result.toString();
    }

    private static boolean isAttributeSet(Object attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        if (attributeValue instanceof String) {
            return ((String)attributeValue).length() > 0;
        }
        if (attributeValue instanceof Integer && (Integer)attributeValue == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeValue instanceof Double && (Double)attributeValue == Double.MIN_VALUE) {
            return false;
        }
        if (attributeValue instanceof Character && ((Character)attributeValue).charValue() == '\u0000') {
            return false;
        }
        if (attributeValue instanceof Float && ((Float)attributeValue).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeValue instanceof Short && (Short)attributeValue == Short.MIN_VALUE) {
            return false;
        }
        if (attributeValue instanceof Byte && (Byte)attributeValue == -128) {
            return false;
        }
        if (attributeValue instanceof Long && (Long)attributeValue == Long.MIN_VALUE) {
            return false;
        }
        if (attributeValue instanceof Collection || attributeValue instanceof Map) {
            return true;
        }
        return attributeValue.toString().length() > 0;
    }

    public static boolean shouldRenderAttribute(Object attributeValue) {
        if (!RenderKitUtils.isAttributeSet(attributeValue)) {
            return false;
        }
        if (attributeValue instanceof Boolean && Boolean.FALSE.equals(attributeValue)) {
            return false;
        }
        return attributeValue.toString().length() > 0;
    }

    public static String prefixAttributeName(String attributeName, boolean isXhtmlMode) {
        if (isXhtmlMode && Arrays.binarySearch(XHTML_ATTRIBUTE_NAMES, attributeName) >= 0) {
            return XHTML_ATTRIBUTE_PREFIX + attributeName;
        }
        return attributeName;
    }

    public static String prefixAttributeName(String attributeName, ResponseWriter responseWriter) {
        return RenderKitUtils.prefixAttributeName(attributeName, XHTML_CONTENT_TYPE.equals(responseWriter.getContentType()));
    }

    public static void renderAttribute(FacesContext facesContext, String attributeName, Object attributeValue) throws IOException {
        if (!RenderKitUtils.shouldRenderAttribute(attributeValue)) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        String prefixedAttributeName = RenderKitUtils.prefixAttributeName(attributeName, writer);
        if (Arrays.binarySearch(URI_ATTRIBUTE_NAMES, attributeName) >= 0) {
            writer.writeURIAttribute(prefixedAttributeName, attributeValue, null);
        } else if (Arrays.binarySearch(BOOLEAN_ATTRIBUTE_NAMES, attributeName) >= 0) {
            boolean booleanAttributeValue = Boolean.valueOf(String.valueOf(attributeValue));
            if (booleanAttributeValue) {
                writer.writeAttribute(prefixedAttributeName, (Object)Boolean.TRUE, null);
            }
        } else {
            writer.writeAttribute(prefixedAttributeName, attributeValue, null);
        }
    }

    public static Object getAttributeAndBehaviorsValue(FacesContext facesContext, UIComponent component, ComponentAttribute componentAttribute) {
        Map<String, List<ClientBehavior>> behaviorsMap;
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (componentAttribute == null) {
            throw new NullPointerException("componentAttribute");
        }
        String componentAttributeName = componentAttribute.getComponentAttributeName();
        Object attributeValue = component.getAttributes().get(componentAttributeName);
        String[] eventNames = componentAttribute.getEventNames();
        if (eventNames.length > 0 && (behaviorsMap = RenderKitUtils.getClientBehaviorsMap(component)).size() > 0) {
            for (String eventName : eventNames) {
                if (!behaviorsMap.containsKey(eventName)) continue;
                List<ClientBehavior> behaviorsList = behaviorsMap.get(eventName);
                if (behaviorsList.isEmpty()) break;
                ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, null, null);
                attributeValue = RenderKitUtils.createBehaviorsChain(attributeValue, behaviorContext, behaviorsList);
                break;
            }
        }
        return attributeValue;
    }

    public static void renderAttributeAndBehaviors(FacesContext facesContext, UIComponent component, ComponentAttribute componentAttribute) throws IOException {
        Object attributeValue = RenderKitUtils.getAttributeAndBehaviorsValue(facesContext, component, componentAttribute);
        RenderKitUtils.renderAttribute(facesContext, componentAttribute.getHtmlAttributeName(), attributeValue);
    }

    public static void renderPassThroughAttributesOptimized(FacesContext context, UIComponent component, Map<String, ComponentAttribute> knownAttributesMap) throws IOException {
        Object attributesThatAreSetObject = component.getAttributes().get(ATTRIBUTES_THAT_ARE_SET);
        if (attributesThatAreSetObject instanceof Collection) {
            boolean disabled = RenderKitUtils.isDisabled(component);
            HashSet<String> handledAttributes = new HashSet<String>(knownAttributesMap.size());
            Collection attributesThatAreSet = (Collection)attributesThatAreSetObject;
            for (Object attributeNameObject : attributesThatAreSet) {
                String attributeName;
                ComponentAttribute knownAttribute;
                if (attributeNameObject == null || (knownAttribute = knownAttributesMap.get(attributeName = attributeNameObject.toString())) == null) continue;
                handledAttributes.add(knownAttribute.getHtmlAttributeName());
                if (disabled && knownAttribute.getEventNames() != null) continue;
                RenderKitUtils.renderAttributeAndBehaviors(context, component, knownAttribute);
            }
            for (ComponentAttribute knownAttribute : knownAttributesMap.values()) {
                if (handledAttributes.contains(knownAttribute.getHtmlAttributeName())) continue;
                RenderKitUtils.renderAttributeAndBehaviors(context, component, knownAttribute);
            }
        } else {
            RenderKitUtils.renderPassThroughAttributes(context, component, knownAttributesMap);
        }
    }

    public static void renderPassThroughAttributes(FacesContext context, UIComponent component, Map<String, ComponentAttribute> knownAttributesMap) throws IOException {
        Collection<ComponentAttribute> attributes = knownAttributesMap.values();
        RenderKitUtils.renderPassThroughAttributes(context, component, attributes);
    }

    public static void renderPassThroughAttributes(FacesContext context, UIComponent component, Collection<ComponentAttribute> attributes) throws IOException {
        boolean disabled = RenderKitUtils.isDisabled(component);
        for (ComponentAttribute knownAttribute : attributes) {
            if (disabled && knownAttribute.getEventNames().length != 0) continue;
            RenderKitUtils.renderAttributeAndBehaviors(context, component, knownAttribute);
        }
    }

    public static String decodeBehaviors(FacesContext context, UIComponent component) {
        if (!(component instanceof ClientBehaviorHolder)) {
            return null;
        }
        ClientBehaviorHolder holder = (ClientBehaviorHolder)component;
        Map behaviors = holder.getClientBehaviors();
        if (behaviors == null || behaviors.isEmpty()) {
            return null;
        }
        ExternalContext externalContext = context.getExternalContext();
        Map parametersMap = externalContext.getRequestParameterMap();
        String behaviorEvent = (String)parametersMap.get(BEHAVIOR_EVENT_NAME);
        if (behaviorEvent == null) {
            return null;
        }
        List behaviorsForEvent = (List)behaviors.get(behaviorEvent);
        String behaviorSource = (String)parametersMap.get(BEHAVIOR_SOURCE_ID);
        String clientId = component.getClientId(context);
        if (behaviorSource != null && behaviorSource.equals(clientId) && behaviorsForEvent != null && !behaviorsForEvent.isEmpty()) {
            for (ClientBehavior behavior : behaviorsForEvent) {
                behavior.decode(context, component);
            }
            return behaviorEvent;
        }
        return null;
    }

    public static Attributes attributes() {
        return new Attributes();
    }

    public static Attributes attributes(Enum<?> ... attrs) {
        Attributes res = new Attributes();
        for (Enum<?> attr : attrs) {
            res.generic(attr.toString(), attr.toString(), new String[0]);
        }
        return res;
    }

    public static Attributes attributes(String ... attrs) {
        Attributes res = new Attributes();
        for (String attr : attrs) {
            res.generic(attr, attr, new String[0]);
        }
        return res;
    }

    private static boolean isEmpty(Object o) {
        if (null == o) {
            return true;
        }
        if (o instanceof String) {
            return 0 == ((String)o).length();
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        return false;
    }

    public static void addToScriptHash(Map<String, Object> hash, String name, Object value) {
        RenderKitUtils.addToScriptHash(hash, name, value, null, null);
    }

    public static void addToScriptHash(Map<String, Object> hash, String name, Object value, Object defaultValue) {
        RenderKitUtils.addToScriptHash(hash, name, value, defaultValue, null);
    }

    public static void addToScriptHash(Map<String, Object> hash, String name, Object value, Object defaultValue, ScriptHashVariableWrapper wrapper) {
        ScriptHashVariableWrapper wrapperOrDefault;
        ScriptHashVariableWrapper scriptHashVariableWrapper = wrapperOrDefault = wrapper != null ? wrapper : ScriptHashVariableWrapper.noop;
        if (!RenderKitUtils.isEmpty(value) && RenderKitUtils.isAttributeSet(value)) {
            if (defaultValue != null) {
                if (!String.valueOf(defaultValue).equals(value.toString())) {
                    hash.put(name, wrapperOrDefault.wrap(value));
                }
            } else if (!(value instanceof Boolean) || ((Boolean)value).booleanValue()) {
                hash.put(name, wrapperOrDefault.wrap(value));
            }
        }
    }

    public static void addToScriptHash(Map<String, Object> hash, FacesContext facesContext, UIComponent component, Attributes attributes, ScriptHashVariableWrapper wrapper) {
        boolean disabled = RenderKitUtils.isDisabled(component);
        for (ComponentAttribute knownAttribute : attributes) {
            if (disabled && knownAttribute.getEventNames().length != 0) continue;
            String attributeName = knownAttribute.getHtmlAttributeName();
            RenderKitUtils.addToScriptHash(hash, attributeName, RenderKitUtils.getAttributeAndBehaviorsValue(facesContext, component, knownAttribute), knownAttribute.getDefaultValue(), wrapper);
        }
    }

    public static String toScriptArgs(Object ... objects) {
        int lastNonNullIdx;
        if (objects == null) {
            return "";
        }
        for (lastNonNullIdx = objects.length - 1; 0 <= lastNonNullIdx && RenderKitUtils.isEmpty(objects[lastNonNullIdx]); --lastNonNullIdx) {
        }
        if (lastNonNullIdx < 0) {
            return "";
        }
        if (lastNonNullIdx == 0) {
            return ScriptUtils.toScript(objects[lastNonNullIdx]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= lastNonNullIdx; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(ScriptUtils.toScript(objects[i]));
        }
        return sb.toString();
    }

    public static String getResourcePath(FacesContext context, String library, String resourceName) {
        String path = null;
        if (resourceName != null) {
            Resource resource;
            ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
            Resource resource2 = resource = library != null ? resourceHandler.createResource(resourceName, library) : resourceHandler.createResource(resourceName);
            if (resource != null) {
                path = resource.getRequestPath();
            }
        }
        return path;
    }

    public static String getResourceURL(String url, FacesContext context) {
        if (null == url) {
            return null;
        }
        Application application = context.getApplication();
        ExternalContext externalContext = context.getExternalContext();
        String value = url;
        if (value.length() == 0 || value.charAt(0) != '/' || !value.startsWith(externalContext.getRequestContextPath())) {
            value = application.getViewHandler().getResourceURL(context, value);
        }
        return externalContext.encodeResourceURL(value);
    }

    public static Object getFirstNonEmptyAttribute(String attributeName, UIComponent component) {
        Object attributeValue = component.getAttributes().get(attributeName);
        return !RenderKitUtils.isEmpty(attributeValue) ? attributeValue : null;
    }

    public static Object getFirstNonEmptyAttribute(String attributeName, UIComponent componentA, UIComponent componentB) {
        Object attributeValue = componentA.getAttributes().get(attributeName);
        if (!RenderKitUtils.isEmpty(attributeValue)) {
            return attributeValue;
        }
        attributeValue = componentB.getAttributes().get(attributeName);
        if (!RenderKitUtils.isEmpty(attributeValue)) {
            return attributeValue;
        }
        return null;
    }

    public static Object getFirstNonEmptyAttribute(String attributeName, UIComponent ... components) {
        for (UIComponent component : components) {
            Object attributeValue = component.getAttributes().get(attributeName);
            if (RenderKitUtils.isEmpty(attributeValue)) continue;
            return attributeValue;
        }
        return null;
    }

    public static String getBehaviorSourceId(FacesContext facesContext) {
        return (String)facesContext.getExternalContext().getRequestParameterMap().get(BEHAVIOR_SOURCE_ID);
    }

    public static boolean hasFacet(UIComponent component, String facetName) {
        return component.getFacet(facetName) != null && component.getFacet(facetName).isRendered();
    }

    public static <T> T evaluateAttribute(String attribute, UIComponent component, FacesContext context) {
        Object evaluatedValue;
        ValueExpression valueExpression = component.getValueExpression(attribute);
        if (valueExpression != null && (evaluatedValue = valueExpression.getValue(context.getELContext())) != null) {
            return (T)evaluatedValue;
        }
        return (T)component.getAttributes().get(attribute);
    }

    public static final class Attributes
    extends TreeSet<ComponentAttribute> {
        private ComponentAttribute last;

        public void render(FacesContext context, UIComponent component) throws IOException {
            RenderKitUtils.renderPassThroughAttributes(context, component, this);
        }

        public Attributes generic(String name, String componentAttribute, String ... events) {
            ComponentAttribute attribute = this.createAttribute(name, componentAttribute);
            attribute.setEventNames(events);
            attribute.setKind(ComponentAttribute.Kind.GENERIC);
            return this;
        }

        private ComponentAttribute createAttribute(String name, String componentAttribute) {
            ComponentAttribute attribute = new ComponentAttribute(name);
            attribute.setComponentAttributeName(componentAttribute);
            this.add(attribute);
            this.last = attribute;
            return attribute;
        }

        public Attributes uri(String name, String componentAttribute) {
            ComponentAttribute attribute = this.createAttribute(name, componentAttribute);
            attribute.setKind(ComponentAttribute.Kind.URI);
            return this;
        }

        public Attributes bool(String name, String componentAttribute) {
            ComponentAttribute attribute = this.createAttribute(name, componentAttribute);
            attribute.setKind(ComponentAttribute.Kind.BOOL);
            return this;
        }

        public Attributes defaultValue(Object value) {
            this.last.setDefaultValue(value);
            return this;
        }
    }

    public static enum ScriptHashVariableWrapper {
        noop{

            @Override
            Object wrap(Object o) {
                return o;
            }
        }
        ,
        asArray{

            @Override
            Object wrap(Object o) {
                return RenderKitUtils.asArray(o);
            }
        }
        ,
        eventHandler{

            @Override
            Object wrap(Object o) {
                return new JSFunctionDefinition("event").addToBody(o);
            }
        };


        abstract Object wrap(Object var1);
    }
}

