/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.richfaces.exception.FileUploadException;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.UploadedFile;
import org.richfaces.request.BaseMultipartRequest;
import org.richfaces.request.MultipartRequest;
import org.richfaces.request.MultipartRequestParser;
import org.richfaces.request.ProgressControl;

public class MultipartRequest25
extends BaseMultipartRequest {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final Function<Collection<String>, Object> MULTIMAP_VALUE_TRANSFORMER = new Function<Collection<String>, Object>(){

        public Object apply(Collection<String> input) {
            if (input.isEmpty()) {
                return null;
            }
            if (input.size() == 1) {
                return Iterables.get(input, (int)0);
            }
            return input.toArray(new String[input.size()]);
        }
    };
    private MultipartRequestParser requestParser;
    private MultipartRequest.ResponseState responseState;
    private Iterable<UploadedFile> uploadedFiles;
    private Multimap<String, String> params;

    public MultipartRequest25(HttpServletRequest request, String uploadId, ProgressControl progressControl, MultipartRequestParser requestParser) {
        super(request, uploadId, progressControl);
        this.requestParser = requestParser;
    }

    private void parseIfNecessary() {
        if (this.responseState != null) {
            return;
        }
        try {
            this.requestParser.parse();
            this.uploadedFiles = this.requestParser.getUploadedFiles();
            this.params = this.requestParser.getParameters();
            this.responseState = MultipartRequest.ResponseState.ok;
        }
        catch (FileUploadException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            this.responseState = MultipartRequest.ResponseState.serverError;
        }
    }

    public Enumeration getParameterNames() {
        HashSet result = Sets.newHashSet();
        Enumeration names = super.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            result.add(name);
        }
        this.parseIfNecessary();
        result.addAll(this.params.keySet());
        return Iterators.asEnumeration(result.iterator());
    }

    public String getParameter(String name) {
        String parameter = super.getParameter(name);
        if (parameter != null) {
            return parameter;
        }
        this.parseIfNecessary();
        Collection values = this.params.get((Object)name);
        if (values.isEmpty()) {
            return null;
        }
        return (String)Iterables.get((Iterable)values, (int)0);
    }

    public String[] getParameterValues(String name) {
        String[] parameterValues = super.getParameterValues(name);
        if (parameterValues != null) {
            return parameterValues;
        }
        this.parseIfNecessary();
        Collection values = this.params.get((Object)name);
        if (values.isEmpty()) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public Map getParameterMap() {
        HashMap parameterMap = Maps.newHashMap((Map)super.getParameterMap());
        this.parseIfNecessary();
        parameterMap.putAll(Maps.transformValues((Map)this.params.asMap(), MULTIMAP_VALUE_TRANSFORMER));
        return parameterMap;
    }

    @Override
    public Iterable<UploadedFile> getUploadedFiles() {
        this.parseIfNecessary();
        return this.uploadedFiles;
    }

    @Override
    public void release() {
        super.release();
        if (this.uploadedFiles != null) {
            for (UploadedFile uploadedFile : this.uploadedFiles) {
                try {
                    uploadedFile.delete();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public MultipartRequest.ResponseState getResponseState() {
        this.parseIfNecessary();
        return this.responseState;
    }
}

