/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import java.util.Collection;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.richfaces.exception.FileUploadException;
import org.richfaces.model.UploadedFile;
import org.richfaces.request.BaseMultipartRequest;
import org.richfaces.request.MultipartRequest;
import org.richfaces.request.MultipartRequestParser;
import org.richfaces.request.ProgressControl;
import org.richfaces.request.UploadedFile30;

public class MultipartRequest30
extends BaseMultipartRequest {
    private MultipartRequest.ResponseState state = MultipartRequest.ResponseState.ok;
    private Iterable<UploadedFile> uploadedFiles = this.initializeUploadedFiles();

    public MultipartRequest30(HttpServletRequest request, String uploadId, ProgressControl progressControl) {
        super(request, uploadId, progressControl);
    }

    private Iterable<UploadedFile> initializeUploadedFiles() {
        try {
            Collection parts = super.getParts();
            LinkedList<UploadedFile> files = new LinkedList<UploadedFile>();
            for (Part part : parts) {
                String contentDisposition = part.getHeader("Content-Disposition");
                String filename = MultipartRequestParser.parseFileName(contentDisposition);
                if (filename == null) continue;
                files.add(new UploadedFile30(part.getName(), filename, part));
            }
            return files;
        }
        catch (Exception e) {
            this.state = MultipartRequest.ResponseState.serverError;
            throw new FileUploadException("couldn't parse request parts", e);
        }
    }

    @Override
    public MultipartRequest.ResponseState getResponseState() {
        return this.state;
    }

    @Override
    public Iterable<UploadedFile> getUploadedFiles() {
        return this.uploadedFiles;
    }
}

