/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.URLResource;
import org.richfaces.resource.external.MappedResourceFactory;
import org.richfaces.resource.mapping.LibraryResourceMapper;
import org.richfaces.resource.mapping.PropertiesResourceMapper;
import org.richfaces.resource.mapping.ResourceAggregator;
import org.richfaces.resource.mapping.ResourceMapper;
import org.richfaces.resource.mapping.ResourceMapping;
import org.richfaces.resource.mapping.ResourcePath;
import org.richfaces.services.Initializable;
import org.richfaces.services.ServiceLoader;
import org.richfaces.services.ServiceUtils;

public class MappedResourceFactoryImpl
implements MappedResourceFactory,
Initializable {
    private List<ResourceMapper> mappers;
    private List<String> resourceLibrariesToMap = Arrays.asList("org.richfaces", "io.richwidgets", "bootstrap", "font-awesome", "com.jqueryui", "org.richfaces.ckeditor");

    @Override
    public void init() {
        LinkedList<ResourceMapper> mappers = new LinkedList<ResourceMapper>();
        mappers.add(new PropertiesResourceMapper());
        for (String resourceLibrary : this.resourceLibrariesToMap) {
            mappers.add(new LibraryResourceMapper(resourceLibrary));
        }
        mappers.addAll(ServiceLoader.loadServices(ResourceMapper.class));
        ServiceUtils.sortByPriority(mappers);
        ServiceUtils.initialize(mappers);
        this.mappers = Collections.unmodifiableList(mappers);
    }

    @Override
    public void release() {
        ServiceUtils.release(this.mappers);
        this.mappers = null;
    }

    @Override
    public Resource createResource(FacesContext context, ResourceKey resourceKey) {
        for (ResourceMapper mapper : this.mappers) {
            ResourceMapping mapping = mapper.mapResource(resourceKey);
            if (mapping == null) continue;
            ResourcePath path = mapping.getResourcePath(context);
            return new URLResource(path);
        }
        return null;
    }

    @Override
    public Set<ResourceKey> getAggregatedResources(ResourcePath resourcePath) {
        LinkedHashSet aggregatedResources = Sets.newLinkedHashSet();
        for (ResourceMapper mapper : this.mappers) {
            if (!(mapper instanceof ResourceAggregator)) continue;
            aggregatedResources.addAll(((ResourceAggregator)((Object)mapper)).getAggregatedResources(resourcePath));
        }
        return aggregatedResources;
    }
}

