/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.Arrays;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ResourceTracker;

public class ResourceTrackerForMyFaces
implements ResourceTracker {
    @Override
    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        if (MimeType.STYLESHEET.contains(mimeType)) {
            return ResourceUtils.isRenderedStylesheet((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        }
        if (MimeType.SCRIPT.contains(mimeType)) {
            return ResourceUtils.isRenderedScript((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        }
        return false;
    }

    @Override
    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        String mimeType = facesContext.getExternalContext().getMimeType(resourceKey.getResourceName());
        if (MimeType.STYLESHEET.contains(mimeType)) {
            ResourceUtils.markStylesheetAsRendered((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        } else if (MimeType.SCRIPT.contains(mimeType)) {
            ResourceUtils.markScriptAsRendered((FacesContext)facesContext, (String)resourceKey.getLibraryName(), (String)resourceKey.getResourceName());
        }
    }

    private static enum MimeType {
        SCRIPT("application/javascript", "text/javascript"),
        STYLESHEET("text/css");

        private String[] types;

        private MimeType(String ... types) {
            this.types = types;
        }

        public boolean contains(String type) {
            return Arrays.asList(this.types).contains(type);
        }
    }
}

