/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.external;

import java.util.concurrent.atomic.AtomicReference;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.external.ResourceTracker;
import org.richfaces.resource.external.ResourceTrackerForMojarra;
import org.richfaces.resource.external.ResourceTrackerForMyFaces;

public class ResourceTrackerImpl
implements ResourceTracker {
    private static final String MYFACES_RESOURCE_UTILS_CLASS = "org.apache.myfaces.shared.renderkit.html.util.ResourceUtils";
    private AtomicReference<ResourceTracker> externalResourceTracker = new AtomicReference();

    @Override
    public boolean isResourceRenderered(FacesContext facesContext, ResourceKey resourceKey) {
        return this.getImplementation().isResourceRenderered(facesContext, resourceKey);
    }

    @Override
    public void markResourceRendered(FacesContext facesContext, ResourceKey resourceKey) {
        this.getImplementation().markResourceRendered(facesContext, resourceKey);
    }

    private ResourceTracker getImplementation() {
        ResourceTracker tracker = this.externalResourceTracker.get();
        if (tracker == null) {
            try {
                this.getClass().getClassLoader().loadClass(MYFACES_RESOURCE_UTILS_CLASS);
                this.externalResourceTracker.compareAndSet(null, new ResourceTrackerForMyFaces());
            }
            catch (Exception e) {
                this.externalResourceTracker.compareAndSet(null, new ResourceTrackerForMojarra());
            }
            tracker = this.externalResourceTracker.get();
        }
        return tracker;
    }
}

