/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import com.google.common.base.Strings;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.mapping.ResourceMapper;
import org.richfaces.resource.mapping.ResourceMapping;
import org.richfaces.resource.mapping.ResourceServletMapping;

public class LibraryResourceMapper
implements ResourceMapper {
    private String resourceLibrary;

    public LibraryResourceMapper(String resourceLibrary) {
        if (resourceLibrary == null) {
            throw new IllegalArgumentException("resourceLibrary must not be null");
        }
        this.resourceLibrary = resourceLibrary;
    }

    @Override
    public ResourceMapping mapResource(ResourceKey resourceKey) {
        String library = Strings.nullToEmpty((String)resourceKey.getLibraryName());
        if (this.resourceLibrary.equals(library)) {
            return new ResourceServletMapping(resourceKey);
        }
        return null;
    }
}

