/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.faces.context.FacesContext;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.optimizer.faces.CurrentResourceContext;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;

public class CSSPackagingProcessor
implements ResourceProcessor {
    private Charset charset;

    public CSSPackagingProcessor(Charset charset) {
        this.charset = charset;
    }

    @Override
    public boolean isSupportedFile(String name) {
        return name.endsWith(".css");
    }

    @Override
    public void process(String outputName, InputSupplier<? extends InputStream> in, OutputSupplier<? extends OutputStream> out, boolean closeAtFinish) throws IOException {
        this.process(outputName, (InputStream)in.getInput(), (OutputStream)out.getOutput(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String outputName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        InputStreamReader reader = null;
        Writer writer = null;
        try {
            reader = new InputStreamReader(in, this.charset);
            writer = new OutputStreamWriter(out, this.charset);
            CurrentResourceContext crc = CurrentResourceContext.getInstance(FacesContext.getCurrentInstance());
            writer.write(String.format("/* resource: %s */\n", ResourceKey.create(crc.getResource())));
            writer.flush();
            ByteStreams.copy((InputStream)in, (OutputStream)out);
            writer.write("\n\n");
            writer.flush();
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader);
            if (closeAtFinish) {
                Closeables.closeQuietly(writer);
            } else {
                writer.flush();
            }
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)reader);
        if (closeAtFinish) {
            Closeables.closeQuietly((Closeable)writer);
        } else {
            writer.flush();
        }
    }
}

