/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.services;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.ResourceParameter;
import org.richfaces.services.DependencyInjector;

public class DependencyInjectionServiceImpl
implements DependencyInjector {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private ConcurrentMap<Class<?>, IntrospectionData> classesCache = new ConcurrentHashMap();

    private void invokeMethod(Object bean, Method method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (method != null) {
            method.setAccessible(true);
            method.invoke(bean, new Object[0]);
        }
    }

    private boolean isUncheckedException(Class<?> type) {
        return RuntimeException.class.isAssignableFrom(type) || Error.class.isAssignableFrom(type);
    }

    private void verifyPostConstructMethod(Method method) {
        Class<?>[] exceptionTypes;
        if (method.getParameterTypes().length != 0) {
            throw new IllegalStateException(MessageFormat.format("Post-construction method {0} has one or more parameters", method.toString()));
        }
        if (!Void.TYPE.equals(method.getReturnType())) {
            throw new IllegalStateException(MessageFormat.format("Post-construction method {0} has incorrect return type", method.toString()));
        }
        if ((method.getModifiers() & 8) != 0) {
            throw new IllegalStateException(MessageFormat.format("Post-construction method {0} is static", method.toString()));
        }
        for (Class<?> exceptionType : exceptionTypes = method.getExceptionTypes()) {
            if (this.isUncheckedException(exceptionType)) continue;
            throw new IllegalStateException(MessageFormat.format("Post-construction method {0} throws checked exception", method.toString()));
        }
    }

    private void inspectMethod(Method method, Class<? extends Annotation> annotationClass, IntrospectionData introspectionData) {
        Annotation annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            this.verifyPostConstructMethod(method);
            if (introspectionData.getPostConstructMethod() != null) {
                throw new IllegalStateException(MessageFormat.format("There are two conflicting post-construction methods: {0} and {1}", method.toString(), introspectionData.getPostConstructMethod().toString()));
            }
            introspectionData.setPostConstructMethod(method);
        }
    }

    private void locatePostConstructMethods(Class<?> clazz, IntrospectionData introspectionData) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            this.inspectMethod(method, PostConstructResource.class, introspectionData);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            this.locatePostConstructMethods(superclass, introspectionData);
        }
    }

    private void locateManagedPropertyFields(Class<?> clazz, Map<String, ResourceParameter> fieldsMap) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String propertyName;
            ResourceParameter dependency = field.getAnnotation(ResourceParameter.class);
            if (dependency == null || fieldsMap.containsKey(propertyName = field.getName())) continue;
            fieldsMap.put(propertyName, dependency);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            this.locateManagedPropertyFields(superclass, fieldsMap);
        }
    }

    private <T extends Annotation> T getAnnotation(PropertyDescriptor descriptor, Class<T> annotationClass) {
        Method readMethod;
        T annotation = null;
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod != null) {
            annotation = writeMethod.getAnnotation(annotationClass);
        }
        if (annotation == null && (readMethod = descriptor.getReadMethod()) != null) {
            annotation = readMethod.getAnnotation(annotationClass);
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateManagedPropertyDescriptors(Class<?> clazz, IntrospectionData introspectionData, Map<String, ResourceParameter> injectableFields) {
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null && (descriptors = beanInfo.getPropertyDescriptors()) != null) {
                for (PropertyDescriptor descriptor : descriptors) {
                    String propertyName = descriptor.getName();
                    ResourceParameter dependency = injectableFields.get(propertyName);
                    if (dependency == null) {
                        dependency = this.getAnnotation(descriptor, ResourceParameter.class);
                    }
                    if (dependency == null) continue;
                    PropertyDependencyInjector injector = new PropertyDependencyInjector(descriptor, dependency);
                    introspectionData.addInjector(propertyName, injector);
                }
            }
        }
        catch (IntrospectionException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), e);
            }
        }
        finally {
            Introspector.flushFromCaches(clazz);
        }
    }

    protected IntrospectionData createIntrospectionData(Class<?> beanClass) {
        IntrospectionData introspectionData = new IntrospectionData();
        HashMap<String, ResourceParameter> injectableFields = new HashMap<String, ResourceParameter>();
        this.locateManagedPropertyFields(beanClass, injectableFields);
        this.locateManagedPropertyDescriptors(beanClass, introspectionData, injectableFields);
        this.locatePostConstructMethods(beanClass, introspectionData);
        return introspectionData;
    }

    @Override
    public void inject(FacesContext context, Object bean) {
        Class<?> beanClass = bean.getClass();
        IntrospectionData introspectionData = (IntrospectionData)this.classesCache.get(beanClass);
        if (introspectionData == null) {
            introspectionData = this.createIntrospectionData(beanClass);
            this.classesCache.put(beanClass, introspectionData);
        }
        try {
            Method postConstructMethod;
            Map<String, Injector<?>> injectorsMap = introspectionData.getInjectorsMap();
            if (!injectorsMap.isEmpty()) {
                for (Injector<?> injector : injectorsMap.values()) {
                    injector.inject(context, bean);
                }
            }
            if ((postConstructMethod = introspectionData.getPostConstructMethod()) != null) {
                this.invokeMethod(bean, postConstructMethod);
            }
        }
        catch (IllegalArgumentException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    private static final class IntrospectionData {
        private Method postConstructMethod = null;
        private Map<String, Injector<?>> injectorsMap = null;

        private IntrospectionData() {
        }

        public Map<String, Injector<?>> getInjectorsMap() {
            if (this.injectorsMap != null) {
                return this.injectorsMap;
            }
            return Collections.emptyMap();
        }

        public void addInjector(String propertyName, Injector<?> injector) {
            if (this.injectorsMap == null) {
                this.injectorsMap = new HashMap();
            }
            this.injectorsMap.put(propertyName, injector);
        }

        public Method getPostConstructMethod() {
            return this.postConstructMethod;
        }

        public void setPostConstructMethod(Method postConstructMethod) {
            this.postConstructMethod = postConstructMethod;
        }
    }

    private static final class PropertyDependencyInjector
    extends Injector<ResourceParameter> {
        public PropertyDependencyInjector(PropertyDescriptor propertyDescriptor, ResourceParameter dependency) {
            super(propertyDescriptor, dependency);
        }

        private Object getExpressionValue(FacesContext context, String expressionString, Class<?> expectedType) {
            ExpressionFactory expressionFactory = context.getApplication().getExpressionFactory();
            ValueExpression expression = expressionFactory.createValueExpression(context.getELContext(), expressionString, expectedType);
            return expression.getValue(context.getELContext());
        }

        @Override
        protected Object evaluateProperty(FacesContext context, Class<?> propertyType) {
            String defaultValue;
            Class expectedType = !propertyType.isPrimitive() ? Object.class : propertyType;
            ResourceParameter resourceParameter = (ResourceParameter)this.getDependency();
            String expression = resourceParameter.expression();
            String name = resourceParameter.name();
            if (expression.length() != 0 && name.length() != 0) {
                throw new IllegalStateException(MessageFormat.format("'name' and 'expression' should not be specified simultaneously: {0}", resourceParameter));
            }
            Object propertyValue = null;
            if (expression.length() != 0) {
                propertyValue = this.getExpressionValue(context, expression, expectedType);
            } else {
                if (name.length() == 0) {
                    name = this.getPropertyDescriptor().getName();
                }
                Map parameters = (Map)context.getAttributes().get("rfResourceParam");
                propertyValue = parameters.get(name);
            }
            if ((propertyValue == null || "".equals(propertyValue)) && (defaultValue = resourceParameter.defaultValue()) != null && defaultValue.length() != 0) {
                propertyValue = this.getExpressionValue(context, defaultValue, expectedType);
            }
            if (propertyValue != null) {
                propertyValue = context.getApplication().getExpressionFactory().coerceToType(propertyValue, propertyType);
            }
            return propertyValue;
        }
    }

    private static abstract class Injector<T extends Annotation> {
        private PropertyDescriptor propertyDescriptor;
        private T dependency;

        public Injector(PropertyDescriptor propertyDescriptor, T dependency) {
            this.propertyDescriptor = propertyDescriptor;
            this.dependency = dependency;
        }

        protected T getDependency() {
            return this.dependency;
        }

        protected PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDescriptor;
        }

        protected abstract Object evaluateProperty(FacesContext var1, Class<?> var2);

        public void inject(FacesContext context, Object bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Method writeMethod = this.propertyDescriptor.getWriteMethod();
            if (writeMethod == null) {
                throw new IllegalStateException(MessageFormat.format("Write method for property {0} doesn't exist", this.propertyDescriptor.getName()));
            }
            writeMethod.invoke(bean, this.evaluateProperty(context, this.propertyDescriptor.getPropertyType()));
        }
    }
}

