/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.services;

import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.richfaces.services.ServiceException;

public final class ServiceLoader {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private static final Pattern LEGAL_JAVA_NAME = Pattern.compile("^(([A-Za-z0-9_])+[\\.\\$])+[A-Z]([A-Za-z0-9_]*)$");

    private ServiceLoader() {
    }

    public static <S> Collection<S> loadServices(Class<S> serviceClass) throws ServiceException {
        Collection<Class<S>> serviceClasses = ServiceLoader.loadServiceClasses(serviceClass);
        ArrayList<S> instances = new ArrayList<S>();
        for (Class<S> implementationClass : serviceClasses) {
            instances.add(ServiceLoader.createInstance(implementationClass));
        }
        return instances;
    }

    public static <S> S loadService(Class<S> serviceClass, Class<? extends S> defaultImplementation) {
        Collection<Class<S>> serviceClasses = ServiceLoader.loadServiceClasses(serviceClass);
        try {
            return ServiceLoader.createInstance((Class)Iterables.getLast(serviceClasses));
        }
        catch (NoSuchElementException e) {
            return ServiceLoader.createInstance(defaultImplementation);
        }
    }

    public static <S> S loadService(Class<S> serviceClass) {
        Collection<Class<S>> serviceClasses = ServiceLoader.loadServiceClasses(serviceClass);
        try {
            return ServiceLoader.createInstance((Class)Iterables.getLast(serviceClasses));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private static <S> S createInstance(Class<? extends S> implementationClass) {
        try {
            return implementationClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ServiceException("Cannot instantiate service class, does it have default constructor ?", e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Cannot instantiate service class, illegal access", e);
        }
    }

    public static <S> Collection<Class<? extends S>> loadServiceClasses(Class<S> serviceClass) throws ServiceException {
        ClassLoader classLoader = ServiceLoader.getClassLoader(serviceClass);
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            Enumeration<URL> resources = classLoader.getResources(META_INF_SERVICES + serviceClass.getName());
            while (resources.hasMoreElements()) {
                names.addAll(ServiceLoader.parse(resources.nextElement()));
            }
        }
        catch (IOException e) {
            throw new ServiceException("Error load service descriptions", e);
        }
        LinkedHashSet<Class<S>> instanceClasses = new LinkedHashSet<Class<S>>();
        for (String className : names) {
            instanceClasses.add(ServiceLoader.loadClass(serviceClass, classLoader, className));
        }
        return instanceClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<String> parse(URL url) throws ServiceException, IOException {
        InputStream inputStream = null;
        try {
            String line;
            URLConnection connection = url.openConnection();
            try {
                connection.setUseCaches(false);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            HashSet<String> names = new HashSet<String>();
            inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            while (null != (line = reader.readLine())) {
                ServiceLoader.parseLine(line, names);
            }
            HashSet<String> hashSet = names;
            return hashSet;
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
    }

    static void parseLine(String line, Collection<String> names) throws ServiceException {
        int commentIndex = line.indexOf(35);
        String name = commentIndex >= 0 ? line.substring(0, commentIndex) : line;
        if ((name = name.trim()).length() > 0) {
            if (LEGAL_JAVA_NAME.matcher(name).matches()) {
                names.add(name);
            } else {
                throw new ServiceException("Invalid java class name [" + line + "]");
            }
        }
    }

    private static <S> ClassLoader getClassLoader(Class<S> serviceClass) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = serviceClass.getClassLoader();
        }
        return classLoader;
    }

    private static <S> Class<? extends S> loadClass(Class<S> serviceClass, ClassLoader classLoader, String className) throws ServiceException {
        try {
            Class<?> implementationClass = classLoader.loadClass(className);
            if (serviceClass.isAssignableFrom(implementationClass)) {
                return implementationClass.asSubclass(serviceClass);
            }
            throw new ServiceException("Class " + className + " in not the instance of " + serviceClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException("Class " + className + " not found", e);
        }
    }
}

