/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.richfaces.services.Initializable;
import org.richfaces.services.Prioritizable;

public final class ServiceUtils {
    public static void sortByPriority(List<?> services) {
        Collections.sort(services, new Comparator(){

            public int compare(Object o1, Object o2) {
                int p1 = o1 instanceof Prioritizable ? ((Prioritizable)o1).getPriority() : 0;
                int p2 = o2 instanceof Prioritizable ? ((Prioritizable)o2).getPriority() : 0;
                return p2 - p1;
            }
        });
    }

    public static void initialize(Collection<?> services) {
        for (Object service : services) {
            if (!(service instanceof Initializable)) continue;
            ((Initializable)service).init();
        }
    }

    public static void release(Collection<?> services) {
        for (Object service : services) {
            if (!(service instanceof Initializable)) continue;
            ((Initializable)service).release();
        }
    }
}

