/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.servlet;

import java.io.IOException;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class ResourceServlet
implements Servlet {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final String JAVAX_FACES_RESOURCE_IDENTIFIER = "/javax.faces.resource/";
    public static final String RESOURCE_SERVLET_REQUEST_FLAG = ResourceServlet.class.getName();
    private ServletConfig servletConfig;
    private FacesServlet facesServlet;

    public void init(ServletConfig config) throws ServletException {
        this.servletConfig = config;
        this.facesServlet = new FacesServlet();
        this.facesServlet.init(config);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public void destroy() {
        this.facesServlet.destroy();
        this.facesServlet = null;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletResponse res;
        HttpServletRequest req;
        try {
            req = (HttpServletRequest)request;
            res = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
        this.httpService(req, res);
    }

    private void httpService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.handleRequestByResourceServlet(request)) {
            request.setAttribute(RESOURCE_SERVLET_REQUEST_FLAG, (Object)Boolean.TRUE);
            this.facesServlet.service((ServletRequest)request, (ServletResponse)response);
        } else {
            ResourceServlet.sendResourceNotFound(response);
        }
    }

    private boolean handleRequestByResourceServlet(HttpServletRequest request) {
        String resourcePath = ResourceServlet.getResourcePathFromRequest(request);
        if (resourcePath == null) {
            LOGGER.debug("ResourceServlet detected request which is not JSF resource request: " + request.getPathInfo());
            return false;
        }
        return true;
    }

    private static String getResourcePathFromRequest(HttpServletRequest request) {
        String resourceName = ResourceServlet.decodeResourceURL(request);
        if (resourceName != null) {
            if (resourceName.startsWith(JAVAX_FACES_RESOURCE_IDENTIFIER)) {
                return resourceName.substring(JAVAX_FACES_RESOURCE_IDENTIFIER.length());
            }
            if (resourceName.startsWith("/rfRes/")) {
                return resourceName;
            }
        }
        return null;
    }

    private static String decodeResourceURL(HttpServletRequest request) {
        String resourceName = null;
        String facesMapping = ResourceServlet.getMappingForRequest(request);
        if (facesMapping != null) {
            if (facesMapping.startsWith("/")) {
                resourceName = request.getPathInfo();
            } else {
                String requestServletPath = request.getServletPath();
                resourceName = requestServletPath.substring(0, requestServletPath.length() - facesMapping.length());
            }
        }
        return resourceName;
    }

    private static void sendResourceNotFound(HttpServletResponse response) {
        response.setStatus(404);
    }

    private static String getMappingForRequest(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath == null) {
            return null;
        }
        if (servletPath.length() == 0) {
            return "/";
        }
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            return servletPath;
        }
        int idx = servletPath.lastIndexOf(46);
        if (idx < 0) {
            return servletPath;
        }
        return servletPath.substring(idx);
    }
}

