/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.servlet;

import java.text.MessageFormat;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.servlet.AbstractServletContainerInitializer;
import org.richfaces.servlet.ResourceServlet;

public class ResourceServletContainerInitializer
extends AbstractServletContainerInitializer {
    private static final Logger LOGGER = RichfacesLogger.WEBAPP.getLogger();
    private static final String SKIP_SERVLET_REGISTRATION_PARAM = "org.richfaces.resources.skipResourceServletRegistration";
    public static final String RICHFACES_RESOURCES_DEFAULT_MAPPING = "/org.richfaces.resources/*";

    public void onStartup(Set<Class<?>> c, ServletContext servletContext) throws ServletException {
        if (Boolean.valueOf(servletContext.getInitParameter(SKIP_SERVLET_REGISTRATION_PARAM)).booleanValue()) {
            return;
        }
        try {
            ServletRegistration servletRegistration = this.getServletRegistration(ResourceServlet.class, servletContext);
            if (servletRegistration == null) {
                ResourceServletContainerInitializer.registerServlet(servletContext);
            }
        }
        catch (Exception e) {
            servletContext.log(MessageFormat.format("Exception registering RichFaces Resource Servlet: {0]", e.getMessage()), (Throwable)e);
        }
    }

    private static void registerServlet(ServletContext context) {
        ServletRegistration.Dynamic dynamicRegistration = context.addServlet("AutoRegisteredResourceServlet", ResourceServlet.class);
        dynamicRegistration.addMapping(new String[]{RICHFACES_RESOURCES_DEFAULT_MAPPING});
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Auto-registered servlet " + ResourceServlet.class.getSimpleName() + " with mapping '" + RICHFACES_RESOURCES_DEFAULT_MAPPING + "'");
        }
    }
}

