/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.awt.Color;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceKey;
import org.richfaces.skin.Skin;
import org.richfaces.util.HtmlColor;
import org.richfaces.util.HtmlDimensions;

public abstract class AbstractSkin
implements Skin {
    private Logger LOG = RichfacesLogger.RESOURCE.getLogger();

    protected Integer decodeColor(Object value) {
        if (value instanceof Color) {
            return ((Color)value).getRGB();
        }
        if (value instanceof Integer) {
            return (int)((Integer)value);
        }
        String stringValue = (String)value;
        if (stringValue != null && stringValue.length() != 0) {
            return HtmlColor.decode(stringValue).getRGB();
        }
        return null;
    }

    protected Integer decodeInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String stringValue = (String)value;
        if (stringValue != null && stringValue.length() != 0) {
            return (int)HtmlDimensions.decode(stringValue).doubleValue();
        }
        return null;
    }

    @Override
    public Integer getColorParameter(FacesContext context, String name) {
        return this.decodeColor(this.getParameter(context, name));
    }

    @Override
    public Integer getColorParameter(FacesContext context, String name, Object defaultValue) {
        return this.decodeColor(this.getParameter(context, name, defaultValue));
    }

    @Override
    public Integer getIntegerParameter(FacesContext context, String name) {
        return this.decodeInteger(this.getParameter(context, name));
    }

    @Override
    public Integer getIntegerParameter(FacesContext context, String name, Object defaultValue) {
        return this.decodeInteger(this.getParameter(context, name, defaultValue));
    }

    @Override
    public String imageUrl(String resourceName) {
        String resourcePath;
        if ("plain".equals(this.getName())) {
            return "none";
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, "org.richfaces.ui.images");
        if (resource != null) {
            resourcePath = resource.getRequestPath();
        } else {
            resourcePath = "RES_NOT_FOUND";
            this.LOG.warn("Unable to find or serve resource '" + ResourceKey.create(resourceName, "org.richfaces.ui.images") + "'");
        }
        return String.format("url(%s)", resourcePath);
    }
}

