/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.richfaces.el.ELUtils;
import org.richfaces.l10n.Messages;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinImpl;
import org.richfaces.skin.SkinNotFoundException;
import org.richfaces.util.PropertiesUtil;

public abstract class AbstractSkinFactory
extends SkinFactory {
    private static final String DEFAULT_SKIN_PATH = "META-INF/skins/%s.skin.properties";
    private static final String USER_SKIN_PATH = "%s.skin.properties";
    private static final String[] SKINS_PATHS = new String[]{"META-INF/skins/%s.skin.properties", "%s.skin.properties"};
    private ConcurrentMap<String, FutureTask<Skin>> skins = new ConcurrentHashMap<String, FutureTask<Skin>>();

    protected void processProperties(FacesContext context, Map<Object, Object> properties) {
        ELContext elContext = context.getELContext();
        Application app = context.getApplication();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object propertyObject = entry.getValue();
            if (!(propertyObject instanceof String)) continue;
            String property = (String)propertyObject;
            if (ELUtils.isValueReference(property)) {
                ExpressionFactory expressionFactory = app.getExpressionFactory();
                entry.setValue(expressionFactory.createValueExpression(elContext, property, Object.class));
                continue;
            }
            entry.setValue(property);
        }
    }

    protected Skin buildSkin(FacesContext context, String name) throws SkinNotFoundException {
        Properties skinParams = this.loadProperties(name, SKINS_PATHS);
        this.processProperties(context, skinParams);
        return new SkinImpl(skinParams, name);
    }

    protected Properties loadProperties(String name, String[] paths) throws SkinNotFoundException {
        Properties skinProperties = new Properties();
        int loadedPropertiesCount = 0;
        for (int i = 0; i < paths.length; ++i) {
            String skinPropertiesLocation = paths[i].replaceAll("%s", name);
            if (!PropertiesUtil.loadProperties(skinProperties, skinPropertiesLocation)) continue;
            ++loadedPropertiesCount;
        }
        if (loadedPropertiesCount == 0) {
            throw new SkinNotFoundException(Messages.getMessage("SKIN_NOT_FOUND_ERROR", name));
        }
        return skinProperties;
    }

    @Override
    public Skin getSkin(FacesContext context, String name) {
        FutureTask<Skin> newSkinFuture;
        if (null == name) {
            throw new SkinNotFoundException(Messages.getMessage("NULL_SKIN_NAME_ERROR"));
        }
        FutureTask<Skin> skinFuture = (FutureTask<Skin>)this.skins.get(name);
        if (skinFuture == null && (skinFuture = this.skins.putIfAbsent(name, newSkinFuture = new FutureTask<Skin>(new SkinBuilder(name)))) == null) {
            skinFuture = newSkinFuture;
        }
        try {
            skinFuture.run();
            return (Skin)skinFuture.get();
        }
        catch (InterruptedException e) {
            throw new SkinNotFoundException(Messages.getMessage("SKIN_NOT_FOUND_ERROR", name), e);
        }
        catch (ExecutionException e) {
            throw new SkinNotFoundException(Messages.getMessage("SKIN_NOT_FOUND_ERROR", name), e);
        }
    }

    private final class SkinBuilder
    implements Callable<Skin> {
        private String skinName;

        SkinBuilder(String skinName) {
            this.skinName = skinName;
        }

        @Override
        public Skin call() throws Exception {
            return AbstractSkinFactory.this.buildSkin(FacesContext.getCurrentInstance(), this.skinName);
        }
    }
}

