/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.ajax.queue;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.ui.ajax.ajax.AjaxBehavior;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractAttachQueue
extends UIComponentBase
implements ComponentSystemEventListener {
    public static final String COMPONENT_TYPE = "org.richfaces.ui.AttachQueue";
    public static final String COMPONENT_FAMILY = "org.richfaces.ui.AttachQueue";
    private transient List<UIComponent> componentsToAssociate;
    private transient List<AjaxBehavior> behaviorsToAssociate;

    @Attribute
    public abstract String getRequestGroupingId();

    @Attribute
    public abstract int getRequestDelay();

    @Attribute
    public abstract boolean isIgnoreDupResponses();

    @Attribute
    public abstract String getOnrequestqueue();

    @Attribute
    public abstract String getOnrequestdequeue();

    @Attribute
    public abstract String getName();

    public String getQueueId() {
        return this.getName();
    }

    public String getFamily() {
        return "org.richfaces.ui.AttachQueue";
    }

    private static void immediateAssociateWith(UIComponent component, String queueId) {
        component.getAttributes().put("queueId", queueId);
    }

    private static void immediateAssociateWith(AjaxBehavior behavior, String queueId) {
        behavior.setQueueId(queueId);
    }

    public void associateWith(UIComponent component) {
        if (this.isInView()) {
            AbstractAttachQueue.immediateAssociateWith(component, this.getClientId());
        } else {
            if (this.componentsToAssociate == null) {
                this.componentsToAssociate = new ArrayList<UIComponent>(2);
            }
            this.componentsToAssociate.add(component);
        }
    }

    public void associateWith(AjaxBehavior behavior) {
        if (this.isInView()) {
            AbstractAttachQueue.immediateAssociateWith(behavior, this.getClientId());
        } else {
            if (this.behaviorsToAssociate == null) {
                this.behaviorsToAssociate = new ArrayList<AjaxBehavior>(2);
            }
            this.behaviorsToAssociate.add(behavior);
        }
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (event instanceof PostAddToViewEvent) {
            String queueId = this.getClientId();
            if (this.componentsToAssociate != null) {
                for (UIComponent componentToAssociate : this.componentsToAssociate) {
                    AbstractAttachQueue.immediateAssociateWith(componentToAssociate, queueId);
                }
                this.componentsToAssociate = null;
            }
            if (this.behaviorsToAssociate != null) {
                for (AjaxBehavior ajaxBehavior : this.behaviorsToAssociate) {
                    AbstractAttachQueue.immediateAssociateWith(ajaxBehavior, queueId);
                }
                this.behaviorsToAssociate = null;
            }
        }
    }
}

