/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.behavior;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.ui.behavior.BehaviorStack;

public class BehaviorsAddingComponentHandlerWrapper
extends ComponentHandler
implements FacesWrapper<ComponentHandler> {
    private ComponentHandler componentHandler;

    public BehaviorsAddingComponentHandlerWrapper(ComponentHandler componentHandler) {
        super(componentHandler.getComponentConfig());
        this.componentHandler = componentHandler;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        this.componentHandler.apply(ctx, parent);
    }

    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.componentHandler.applyNextHandler(ctx, c);
    }

    public TagAttribute getBinding() {
        return this.componentHandler.getBinding();
    }

    public Tag getTag() {
        return this.componentHandler.getTag();
    }

    public TagAttribute getTagAttribute(String localName) {
        if (this.componentHandler == null) {
            return this.getComponentConfig().getTag().getAttributes().get(localName);
        }
        return this.componentHandler.getTagAttribute(localName);
    }

    public String getTagId() {
        return this.componentHandler.getTagId();
    }

    public boolean equals(Object obj) {
        return this.componentHandler.equals(obj);
    }

    public int hashCode() {
        return this.componentHandler.hashCode();
    }

    public String toString() {
        return this.componentHandler.toString();
    }

    public boolean isDisabled(FaceletContext ctx) {
        return this.componentHandler.isDisabled(ctx);
    }

    public void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        this.componentHandler.onComponentCreated(ctx, c, parent);
    }

    public void onComponentPopulated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        FacesContext facesContext = ctx.getFacesContext();
        BehaviorStack behaviorStack = BehaviorStack.getBehaviorStack(facesContext, false);
        if (behaviorStack != null && !behaviorStack.isEmpty() && c instanceof ClientBehaviorHolder) {
            ClientBehaviorHolder behaviorHolder = (ClientBehaviorHolder)c;
            behaviorStack.addBehaviors(facesContext, behaviorHolder);
        }
        this.componentHandler.onComponentPopulated(ctx, c, parent);
    }

    public void setAttributes(FaceletContext ctx, Object instance) {
        this.componentHandler.setAttributes(ctx, instance);
    }

    public ComponentHandler getWrapped() {
        return this.componentHandler;
    }
}

