/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.JSFunction;
import org.richfaces.javascript.JSReference;
import org.richfaces.ui.common.AjaxFunction;
import org.richfaces.util.AjaxRendererUtils;
import org.richfaces.util.RendererUtils;

public final class HandlersChain {
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();
    private boolean hasSubmittingBehavior = false;
    private boolean includeClientId = false;
    private List<String> handlers = new ArrayList<String>(2);
    private FacesContext facesContext;
    private UIComponent component;
    private Collection<ClientBehaviorContext.Parameter> parameters;

    public HandlersChain(FacesContext facesContext, UIComponent component) {
        this.facesContext = facesContext;
        this.component = component;
    }

    public HandlersChain(FacesContext facesContext, UIComponent component, boolean includeClientId) {
        this.facesContext = facesContext;
        this.component = component;
        this.includeClientId = includeClientId;
    }

    public HandlersChain(FacesContext facesContext, UIComponent component, Collection<ClientBehaviorContext.Parameter> parameters) {
        this.facesContext = facesContext;
        this.component = component;
        this.parameters = parameters;
    }

    public HandlersChain(FacesContext facesContext, UIComponent component, Collection<ClientBehaviorContext.Parameter> parameters, boolean includeClientId) {
        this.facesContext = facesContext;
        this.component = component;
        this.parameters = parameters;
        this.includeClientId = includeClientId;
    }

    private static boolean isNotEmpty(String s) {
        return s != null && s.length() != 0;
    }

    private List<ClientBehavior> getBehaviorsList(String behaviorName) {
        ClientBehaviorHolder clientBehaviorHolder;
        Map clientBehaviorsMap;
        List behaviors = null;
        if (this.component instanceof ClientBehaviorHolder && (clientBehaviorsMap = (clientBehaviorHolder = (ClientBehaviorHolder)this.component).getClientBehaviors()) != null) {
            behaviors = (List)clientBehaviorsMap.get(behaviorName);
        }
        return behaviors;
    }

    private Collection<ClientBehaviorContext.Parameter> getParameters() {
        if (this.parameters == null) {
            Map<String, Object> parametersMap = RENDERER_UTILS.createParametersMap(this.facesContext, this.component);
            this.parameters = HandlersChain.createParametersList(parametersMap);
        }
        return this.parameters;
    }

    public boolean hasSubmittingBehavior() {
        return this.hasSubmittingBehavior;
    }

    public void addInlineHandlerAsValue(String handlerValue) {
        if (HandlersChain.isNotEmpty(handlerValue)) {
            this.handlers.add(handlerValue);
        }
    }

    public void addInlineHandlerFromAttribute(String attributeName) {
        this.addInlineHandlerAsValue((String)this.component.getAttributes().get(attributeName));
    }

    public void addBehaviors(String domEventName) {
        this.addBehaviors(domEventName, null);
    }

    public void addBehaviors(String domEventName, String logicalEventName) {
        String name = domEventName;
        List<ClientBehavior> behaviorsList = this.getBehaviorsList(domEventName);
        if (behaviorsList == null && logicalEventName != null) {
            behaviorsList = this.getBehaviorsList(logicalEventName);
            name = logicalEventName;
        }
        if (behaviorsList == null) {
            return;
        }
        ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)this.facesContext, (UIComponent)this.component, (String)name, this.includeClientId ? this.component.getClientId(this.facesContext) : null, this.getParameters());
        for (ClientBehavior clientBehavior : behaviorsList) {
            String behaviorScript = clientBehavior.getScript(behaviorContext);
            if (!HandlersChain.isNotEmpty(behaviorScript)) continue;
            if (clientBehavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) {
                this.hasSubmittingBehavior = true;
            }
            this.handlers.add(behaviorScript);
        }
    }

    public void addAjaxSubmitFunction() {
        if (!this.hasSubmittingBehavior()) {
            this.hasSubmittingBehavior = true;
            AjaxFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(this.facesContext, this.component);
            this.addInlineHandlerAsValue(ajaxFunction.toScript());
        }
    }

    public String toScript() {
        String result = null;
        if (!this.handlers.isEmpty()) {
            if (this.handlers.size() == 1) {
                result = this.handlers.get(0);
            } else {
                JSFunction jsFunction = new JSFunction("jsf.util.chain", JSReference.THIS, JSReference.EVENT);
                for (String handler : this.handlers) {
                    jsFunction.addParameter(handler);
                }
                result = jsFunction.toScript();
            }
        }
        return result;
    }

    public static List<ClientBehaviorContext.Parameter> createParametersList(Map<String, Object> parametersMap) {
        ArrayList<ClientBehaviorContext.Parameter> parameters = new ArrayList<ClientBehaviorContext.Parameter>(parametersMap.size());
        for (Map.Entry<String, Object> entry : parametersMap.entrySet()) {
            parameters.add(new ClientBehaviorContext.Parameter(entry.getKey(), entry.getValue()));
        }
        return parameters;
    }
}

