/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.common;

import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.richfaces.ui.behavior.ClientBehavior;

public class BehaviorRule
extends MetaRule {
    public static final BehaviorRule INSTANCE = new BehaviorRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(ClientBehavior.class)) {
            if (!attribute.isLiteral()) {
                Class<Object> type = meta.getPropertyType(name);
                if (type == null) {
                    type = Object.class;
                }
                return new ValueExpressionMetadata(name, type, attribute);
            }
            if (meta != null && meta.getWriteMethod(name) != null) {
                return new LiteralAttributeMetadata(name, attribute.getValue());
            }
        }
        return null;
    }

    public static final class ValueExpressionMetadata
    extends Metadata {
        private final String name;
        private final TagAttribute attr;
        private final Class<?> type;

        public ValueExpressionMetadata(String name, Class<?> type, TagAttribute attr) {
            this.name = name;
            this.attr = attr;
            this.type = type;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ClientBehavior)((Object)instance)).setValueExpression(this.name, this.attr.getValueExpression(ctx, this.type));
        }
    }

    public static final class LiteralAttributeMetadata
    extends Metadata {
        private final String name;
        private final String value;

        public LiteralAttributeMetadata(String name, String value) {
            this.value = value;
            this.name = name;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ClientBehavior)((Object)instance)).setLiteralAttribute(this.name, this.value);
        }
    }
}

