/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.common;

import com.google.common.base.Predicate;
import javax.faces.component.UIComponent;

public final class ComponentPredicates {
    private static final Predicate<UIComponent> IS_RENDERED = new Predicate<UIComponent>(){

        public boolean apply(UIComponent input) {
            return input.isRendered();
        }
    };

    private ComponentPredicates() {
    }

    public static Predicate<UIComponent> isRendered() {
        return IS_RENDERED;
    }

    public static Predicate<UIComponent> withId(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        return new WithIdPredicate(id);
    }

    private static final class WithIdPredicate
    implements Predicate<UIComponent> {
        private final String id;

        public WithIdPredicate(String id) {
            this.id = id;
        }

        public boolean apply(UIComponent input) {
            return this.id.equals(input.getId());
        }
    }
}

