/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHelper;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

public class PartialStateHolderHelper
implements StateHelper {
    private PartialStateHolder stateHolder;
    private boolean isTransient;
    private Map<Serializable, Object> deltaMap;
    private Map<Serializable, Object> defaultMap;

    public PartialStateHolderHelper(PartialStateHolder stateHolder) {
        this.stateHolder = stateHolder;
        this.deltaMap = new HashMap<Serializable, Object>();
        this.defaultMap = new HashMap<Serializable, Object>();
    }

    public Object put(Serializable key, Object value) {
        if (this.stateHolder.initialStateMarked() || value instanceof PartialStateHolder) {
            Object retVal = this.deltaMap.put(key, value);
            if (retVal == null) {
                return this.defaultMap.put(key, value);
            }
            this.defaultMap.put(key, value);
            return retVal;
        }
        return this.defaultMap.put(key, value);
    }

    public Object remove(Serializable key) {
        if (this.stateHolder.initialStateMarked()) {
            Object retVal = this.deltaMap.remove(key);
            if (retVal == null) {
                return this.defaultMap.remove(key);
            }
            this.defaultMap.remove(key);
            return retVal;
        }
        return this.defaultMap.remove(key);
    }

    public Object put(Serializable key, String mapKey, Object value) {
        HashMap<String, Object> map;
        Object ret = null;
        if (this.stateHolder.initialStateMarked()) {
            HashMap<String, Object> dMap = (HashMap<String, Object>)this.deltaMap.get(key);
            if (dMap == null) {
                dMap = new HashMap<String, Object>(5);
                this.deltaMap.put(key, dMap);
            }
            ret = dMap.put(mapKey, value);
        }
        if ((map = (HashMap<String, Object>)this.get(key)) == null) {
            map = new HashMap<String, Object>(8);
            this.defaultMap.put(key, map);
        }
        if (ret == null) {
            return map.put(mapKey, value);
        }
        map.put(mapKey, value);
        return ret;
    }

    public Object get(Serializable key) {
        return this.defaultMap.get(key);
    }

    public Object eval(Serializable key) {
        return this.eval(key, null);
    }

    public Object eval(Serializable key, Object defaultValue) {
        Object retVal = this.get(key);
        if (retVal == null) {
            retVal = this.getValueExpressionValue(key.toString());
        }
        return retVal != null ? retVal : defaultValue;
    }

    protected Object getValueExpressionValue(String name) {
        return null;
    }

    public void add(Serializable key, Object value) {
        ArrayList<Object> items;
        if (this.stateHolder.initialStateMarked()) {
            ArrayList<Object> deltaList = (ArrayList<Object>)this.deltaMap.get(key);
            if (deltaList == null) {
                deltaList = new ArrayList<Object>(4);
                this.deltaMap.put(key, deltaList);
            }
            deltaList.add(value);
        }
        if ((items = (ArrayList<Object>)this.get(key)) == null) {
            items = new ArrayList<Object>(4);
            this.defaultMap.put(key, items);
        }
        items.add(value);
    }

    public Object remove(Serializable key, Object valueOrKey) {
        Object source = this.get(key);
        if (source instanceof Collection) {
            return this.removeFromList(key, valueOrKey);
        }
        if (source instanceof Map) {
            return this.removeFromMap(key, valueOrKey.toString());
        }
        return null;
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.stateHolder.initialStateMarked()) {
            return this.saveMap(context, this.deltaMap);
        }
        return this.saveMap(context, this.defaultMap);
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] savedState = (Object[])state;
        if (savedState[savedState.length - 1] != null) {
            if (((Boolean)savedState[savedState.length - 1]).booleanValue()) {
                this.stateHolder.markInitialState();
            } else {
                this.stateHolder.clearInitialState();
            }
        }
        int length = (savedState.length - 1) / 2;
        for (int i = 0; i < length; ++i) {
            Object value = savedState[i * 2 + 1];
            if (Void.TYPE.equals(value)) {
                value = null;
            }
            Serializable serializable = (Serializable)savedState[i * 2];
            if (value != null) {
                if (value instanceof Collection) {
                    value = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)value);
                } else {
                    Object object = value = value instanceof Serializable ? value : UIComponentBase.restoreAttachedState((FacesContext)context, (Object)value);
                }
            }
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.put(serializable, (String)entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (value instanceof List) {
                List list = (List)this.get(serializable);
                for (Object o : (List)value) {
                    if (list != null && list.contains(o)) continue;
                    this.add(serializable, o);
                }
                continue;
            }
            this.put(serializable, value);
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    private Object saveMap(FacesContext context, Map<Serializable, Object> map) {
        if (map.isEmpty()) {
            if (!this.stateHolder.initialStateMarked()) {
                return new Object[]{this.stateHolder.initialStateMarked()};
            }
            return null;
        }
        Object[] savedState = new Object[map.size() * 2 + 1];
        int i = 0;
        for (Map.Entry<Serializable, Object> entry : map.entrySet()) {
            Class<Void> value = entry.getValue();
            if (value == null) {
                value = Void.TYPE;
            }
            savedState[i * 2] = entry.getKey();
            if (value instanceof Collection || value instanceof StateHolder || !(value instanceof Serializable)) {
                value = UIComponentBase.saveAttachedState((FacesContext)context, value);
            }
            savedState[i * 2 + 1] = value;
            ++i;
        }
        if (!this.stateHolder.initialStateMarked()) {
            savedState[savedState.length - 1] = this.stateHolder.initialStateMarked();
        }
        return savedState;
    }

    private Object removeFromList(Serializable key, Object value) {
        Collection list;
        Collection deltaList;
        Boolean ret = null;
        if ((this.stateHolder.initialStateMarked() || value instanceof PartialStateHolder) && (deltaList = (Collection)this.deltaMap.get(key)) != null) {
            ret = deltaList.remove(value);
            if (deltaList.isEmpty()) {
                this.deltaMap.remove(key);
            }
        }
        if ((list = (Collection)this.get(key)) != null) {
            if (ret == null) {
                ret = list.remove(value);
            } else {
                list.remove(value);
            }
            if (list.isEmpty()) {
                this.defaultMap.remove(key);
            }
        }
        return ret;
    }

    private Object removeFromMap(Serializable key, String mapKey) {
        Map map;
        Map dMap;
        Object ret = null;
        if (this.stateHolder.initialStateMarked() && (dMap = (Map)this.deltaMap.get(key)) != null) {
            ret = dMap.remove(mapKey);
            if (dMap.isEmpty()) {
                this.deltaMap.remove(key);
            }
        }
        if ((map = (Map)this.get(key)) != null) {
            if (ret == null) {
                ret = map.remove(mapKey);
            } else {
                map.remove(mapKey);
            }
            if (map.isEmpty()) {
                this.defaultMap.remove(key);
            }
        }
        if (ret != null && !this.stateHolder.initialStateMarked()) {
            this.deltaMap.remove(key);
        }
        return ret;
    }
}

