/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.FaceletContext;

public final class TagHandlerUtils {
    public static final String FACELET_CONTEXT_KEY;
    private static final String JAVAX_FACES_RETARGETABLE_HANDLERS = "javax.faces.RetargetableHandlers";
    private static final String JAVAX_FACES_ATTACHED_OBJECT_HANDLERS = "javax.faces.view.AttachedObjectHandlers";

    private TagHandlerUtils() {
    }

    public static List<AttachedObjectHandler> getOrCreateRetargetableHandlersList(UIComponent component) {
        Map attrs = component.getAttributes();
        ArrayList list = (ArrayList)attrs.get(JAVAX_FACES_ATTACHED_OBJECT_HANDLERS);
        if (list == null) {
            list = (List)attrs.get(JAVAX_FACES_RETARGETABLE_HANDLERS);
        }
        if (list == null) {
            list = new ArrayList();
            attrs.put(JAVAX_FACES_RETARGETABLE_HANDLERS, list);
            attrs.put(JAVAX_FACES_ATTACHED_OBJECT_HANDLERS, list);
        }
        return list;
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> type) throws ClassNotFoundException, ClassCastException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Class<?> loadedClass = Class.forName(className, false, ccl);
        return loadedClass.asSubclass(type);
    }

    static {
        try {
            FACELET_CONTEXT_KEY = (String)FaceletContext.class.getField("FACELET_CONTEXT_KEY").get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain FACELET_CONTEXT_KEY", e);
        }
    }
}

