/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.drag;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.richfaces.javascript.ScriptWithDependencies;
import org.richfaces.resource.ResourceKey;

public abstract class DnDScript
implements ScriptWithDependencies {
    private static final Set<ResourceKey> BASE_RESOURCES = new LinkedHashSet<ResourceKey>();
    private final String name;

    public DnDScript(String name) {
        this.name = name;
    }

    public Set<ResourceKey> getBaseResources() {
        return BASE_RESOURCES;
    }

    @Override
    public void appendScriptToStringBuilder(StringBuilder stringBuilder) {
        try {
            this.appendScript(stringBuilder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String toScript() {
        return this.name;
    }

    @Override
    public void appendScript(Appendable target) throws IOException {
        target.append(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnDScript other = (DnDScript)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    static {
        BASE_RESOURCES.add(new ResourceKey("jquery.js", "org.richfaces"));
        BASE_RESOURCES.add(new ResourceKey("common/jquery.position.js", "org.richfaces"));
        BASE_RESOURCES.add(new ResourceKey("richfaces.js", "org.richfaces"));
        BASE_RESOURCES.add(new ResourceKey("common/richfaces-base-component.js", "org.richfaces"));
        BASE_RESOURCES.add(new ResourceKey("richfaces-event.js", "org.richfaces"));
        BASE_RESOURCES.add(new ResourceKey("jquery.ui.core.js", "com.jqueryui"));
        BASE_RESOURCES.add(new ResourceKey("jquery.ui.widget.js", "com.jqueryui"));
        BASE_RESOURCES.add(new ResourceKey("jquery.ui.mouse.js", "com.jqueryui"));
        BASE_RESOURCES.add(new ResourceKey("jquery.ui.draggable.js", "com.jqueryui"));
        BASE_RESOURCES.add(new ResourceKey("jquery.ui.droppable.js", "com.jqueryui"));
    }
}

