/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.ResourceParameter;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.ui.images.ColorUtils;

@DynamicUserResource
public class InputNumberSliderBarHandleBackgroundImage
extends AbstractJava2DUserResource
implements StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(24, 48);
    private Integer basicColor;
    private String colorParam;

    public InputNumberSliderBarHandleBackgroundImage() {
        super(ImageType.GIF, DIMENSION);
    }

    @PostConstructResource
    public void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance(context).getSkin(context);
        Skin defaultSkin = SkinFactory.getInstance(context).getDefaultSkin(context);
        this.basicColor = skin.getColorParameter(context, this.colorParam);
        if (this.basicColor == null) {
            this.basicColor = defaultSkin.getColorParameter(context, this.colorParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createMainStage() {
        Color progressbarBackgroundColor = new Color(this.basicColor);
        Color progressbarSpiralColor = ColorUtils.adjustLightness(progressbarBackgroundColor, 0.2f);
        Dimension dimension = this.getDimension();
        BufferedImage retVal = this.getImageType().createImage(dimension.width, dimension.height * 2);
        Graphics g = retVal.getGraphics();
        try {
            g.setColor(progressbarBackgroundColor);
            g.fillRect(0, 0, dimension.width, dimension.height * 2);
            g.setColor(progressbarSpiralColor);
            for (int k : new int[]{-24, 0, 24, 48, 72}) {
                g.fillPolygon(new int[]{0, 24, 24, 0}, new int[]{24 + k, k, 12 + k, 36 + k}, 4);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return retVal;
    }

    @Override
    public void paint(Graphics2D g2d) {
        Dimension dimension = this.getDimension();
        BufferedImage mainStage = this.createMainStage();
        g2d.drawImage(mainStage, null, null);
        Color progressbarBackgroundColor = new Color(this.basicColor);
        Color progressbarShadowStartColor = ColorUtils.overwriteAlpha(ColorUtils.adjustLightness(progressbarBackgroundColor, 0.7f), 0.6f);
        Color progressbarShadowEndColor = ColorUtils.overwriteAlpha(ColorUtils.adjustLightness(progressbarBackgroundColor, 0.3f), 0.6f);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, progressbarShadowStartColor, 0.0f, 7.0f, progressbarShadowEndColor));
        g2d.fillRect(0, 0, dimension.width, 7);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.basicColor);
    }

    @Override
    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.basicColor = dataInput.readInt();
    }

    @ResourceParameter(defaultValue="selectControlColor")
    public void setColorParam(String colorParam) {
        this.colorParam = colorParam;
    }
}

