/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.DynamicUserResource;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicUserResource
public abstract class OneColorBasedResource
extends AbstractJava2DUserResource
implements StateHolderResource {
    private String basicColorParamName;
    private Color basicColor;

    public OneColorBasedResource(Dimension dimension, String basicColorParamName) {
        super(ImageType.GIF, dimension);
        this.basicColorParamName = basicColorParamName;
    }

    protected Color getBasicColor() {
        return this.basicColor;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        Skin skin = SkinFactory.getInstance(context).getSkin(context);
        Integer colorParameter = skin.getColorParameter(context, this.basicColorParamName);
        if (colorParameter == null) {
            Skin defaultSkin = SkinFactory.getInstance(context).getDefaultSkin(context);
            colorParameter = defaultSkin.getColorParameter(context, this.basicColorParamName);
        }
        dataOutput.writeInt(colorParameter);
    }

    @Override
    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.basicColor = new Color(dataInput.readInt());
    }

    @Override
    public abstract void paint(Graphics2D var1);
}

