/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.input.autocomplete;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import javax.el.MethodExpression;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.cdk.annotations.Signature;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.ui.attribute.AjaxEventsProps;
import org.richfaces.ui.attribute.EventsKeyProps;
import org.richfaces.ui.attribute.EventsMouseProps;
import org.richfaces.ui.attribute.FocusProps;
import org.richfaces.ui.attribute.StyleClassProps;
import org.richfaces.ui.attribute.StyleProps;
import org.richfaces.ui.common.meta.MetaComponentEncoder;
import org.richfaces.ui.common.meta.MetaComponentResolver;
import org.richfaces.ui.input.autocomplete.AutocompleteMode;
import org.richfaces.ui.input.autocomplete.AutocompleteRendererBase;

public abstract class AbstractAutocomplete
extends UIInput
implements AjaxEventsProps,
FocusProps,
EventsKeyProps,
EventsMouseProps,
StyleProps,
StyleClassProps,
MetaComponentResolver,
MetaComponentEncoder {
    public static final String COMPONENT_TYPE = "org.richfaces.ui.Autocomplete";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    static final String SUGGESTIONS_META_COMPONENT_ID = "suggestions";

    @Attribute
    public abstract Object getAutocompleteList();

    @Attribute(signature=@Signature(returnType=Object.class, parameters={FacesContext.class, UIComponent.class, String.class}))
    public abstract MethodExpression getAutocompleteMethod();

    public abstract void setAutocompleteMethod(MethodExpression var1);

    @Attribute(literal=true)
    public abstract String getVar();

    @Attribute(literal=false)
    public abstract Object getFetchValue();

    @Attribute(defaultValue="1")
    public abstract int getMinChars();

    @Attribute(defaultValue="AutocompleteMode.cachedAjax")
    public abstract AutocompleteMode getMode();

    @Attribute
    public abstract String getTokens();

    @Attribute(defaultValue="true")
    public abstract boolean isAutofill();

    @Attribute
    public abstract boolean isDisabled();

    @Attribute
    public abstract boolean isShowButton();

    @Attribute(defaultValue="true")
    public abstract boolean isSelectFirst();

    @Attribute
    public abstract String getClientFilterFunction();

    @Attribute(events={@EventName(value="select")})
    public abstract String getOnselect();

    @Deprecated
    @Attribute(events={@EventName(value="selectitem")})
    public abstract String getOnselectitem();

    @Attribute(events={@EventName(value="change", defaultEvent=true)})
    public abstract String getOnchange();

    @Attribute(events={@EventName(value="close")})
    public abstract String getOnclose();

    @Override
    @Attribute(events={@EventName(value="focus")})
    public abstract String getOnfocus();

    @Attribute(events={@EventName(value="open")})
    public abstract String getOnopen();

    @Attribute(events={@EventName(value="response")})
    public abstract String getOnresponse();

    @Attribute(events={@EventName(value="search")})
    public abstract String getOnsearch();

    @Attribute(events={@EventName(value="error")})
    public abstract String getOnerror();

    String getSuggestionsMetaComponentId(FacesContext facesContext) {
        return this.resolveClientId(facesContext, (UIComponent)this, SUGGESTIONS_META_COMPONENT_ID);
    }

    @Override
    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (SUGGESTIONS_META_COMPONENT_ID.equals(metaComponentId)) {
            return this.getClientId(facesContext) + '@' + metaComponentId;
        }
        return null;
    }

    @Override
    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    public boolean visitTree(VisitContext context, VisitCallback callback) {
        ExtendedVisitContext extendedVisitContext;
        if (context instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)context).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            VisitResult result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, SUGGESTIONS_META_COMPONENT_ID);
            if (result == VisitResult.COMPLETE) {
                return true;
            }
            if (result == VisitResult.REJECT) {
                return false;
            }
        }
        return super.visitTree(context, callback);
    }

    @Override
    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        ((AutocompleteRendererBase)this.getRenderer(context)).encodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    @Attribute(generate=false, hidden=true, defaultValue="Layout.list")
    public String getLayout() {
        return this.getChildCount() > 0 && Iterables.all((Iterable)this.getChildren(), (Predicate)Predicates.instanceOf(UIColumn.class)) ? "table" : "list";
    }

    @Deprecated
    public void setLayout(String layout) {
        if (FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development)) {
            String message = "Autocomplete @layout attribute was deprecated in 5.0. The layout of the component is determined from provide children.";
            RichfacesLogger.COMPONENTS.getLogger().warn(message);
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, message, message));
        }
    }
}

