/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.input.autocomplete;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.input.autocomplete.AbstractAutocomplete;
import org.richfaces.ui.input.autocomplete.AutocompleteMode;
import org.richfaces.ui.input.autocomplete.AutocompleteRendererBase;

@ResourceDependencies(value={@ResourceDependency(name="bootstrap.css", library="bootstrap", target=""), @ResourceDependency(name="font-awesome.css", library="font-awesome", target=""), @ResourceDependency(name="input/autocomplete.css", library="io.richwidgets", target=""), @ResourceDependency(name="jsf.js", library="javax.faces", target=""), @ResourceDependency(name="jquery.js", library="org.richfaces", target=""), @ResourceDependency(name="richfaces.js", library="org.richfaces", target=""), @ResourceDependency(name="richfaces-queue.reslib", library="org.richfaces", target=""), @ResourceDependency(name="jquery.ui.core.js", library="com.jqueryui", target=""), @ResourceDependency(name="jquery.ui.widget.js", library="com.jqueryui", target=""), @ResourceDependency(name="jquery.ui.position.js", library="com.jqueryui", target=""), @ResourceDependency(name="jquery.ui.menu.js", library="com.jqueryui", target=""), @ResourceDependency(name="jquery.ui.autocomplete.js", library="com.jqueryui", target=""), @ResourceDependency(name="input/autocomplete.js", library="io.richwidgets", target=""), @ResourceDependency(name="bridge/bridge-base.js", library="org.richfaces", target=""), @ResourceDependency(name="bridge/input/autocomplete-bridge.js", library="org.richfaces", target="")})
public class AutocompleteRenderer
extends AutocompleteRendererBase {
    private static final RenderKitUtils.Attributes PASS_THROUGH_ATTRIBUTES1 = RenderKitUtils.attributes().generic("accept", "accept", new String[0]).generic("accesskey", "accesskey", new String[0]).generic("align", "align", new String[0]).generic("alt", "alt", new String[0]).bool("checked", "checked").generic("dir", "dir", new String[0]).generic("lang", "lang", new String[0]).generic("maxlength", "maxlength", new String[0]).generic("onblur", "onblur", "blur").generic("onclick", "onclick", "click").generic("ondblclick", "ondblclick", "dblclick").generic("onkeydown", "onkeydown", "onkeydown").generic("onkeypress", "onkeypress", "onkeypress").generic("onkeyup", "onkeyup", "onkeyup").generic("onmousedown", "onmousedown", "mousedown").generic("onmousemove", "onmousemove", "mousemove").generic("onmouseout", "onmouseout", "mouseout").generic("onmouseover", "onmouseover", "mouseover").generic("onmouseup", "onmouseup", "mouseup").generic("onselect", "onselect", "select").bool("readonly", "readonly").generic("role", "role", new String[0]).generic("size", "size", new String[0]).uri("src", "src").generic("style", "style", new String[0]).generic("tabindex", "tabindex", new String[0]).generic("title", "title", new String[0]).uri("usemap", "usemap");
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH1 = RenderKitUtils.attributes().generic("token", "tokens", new String[0]).generic("mode", "mode", new String[0]).defaultValue((Object)AutocompleteMode.cachedAjax).generic("showButton", "showButton", new String[0]).defaultValue(false).generic("minLength", "minChars", new String[0]).defaultValue(1).generic("autoFocus", "selectFirst", new String[0]).defaultValue(true);
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH2 = RenderKitUtils.attributes().generic("select", "onselectitem", "selectitem").generic("select", "onselect", "select").generic("change", "onchange", "change").generic("close", "onclose", "close").generic("focus", "onfocus", "focus").generic("open", "onopen", "open").generic("response", "onresponse", "response").generic("search", "onsearch", "search");

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    public void renderSuggestionsAsList(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterable items) throws IOException {
        AbstractAutocomplete component = (AbstractAutocomplete)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("ul", (UIComponent)component);
        String value = AutocompleteRenderer.convertToString(clientId) + "Suggestions";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.writeAttribute("style", (Object)"display: none", null);
        Object savedVar = this.saveVar(facesContext, component.getVar());
        for (Object item : items) {
            this.setVar(facesContext, component.getVar(), item);
            responseWriter.startElement("li", (UIComponent)component);
            Object value2 = component.getFetchValue();
            if (null != value2 && RenderKitUtils.shouldRenderAttribute(value2)) {
                responseWriter.writeAttribute("data-label", value2, null);
            }
            if (AutocompleteRenderer.isEmpty(component.getChildren())) {
                Object text = item;
                if (text != null) {
                    responseWriter.writeText(text, null);
                }
            } else {
                for (UIComponent c : component.getChildren()) {
                    c.encodeAll(facesContext);
                }
            }
            responseWriter.endElement("li");
        }
        this.setVar(facesContext, component.getVar(), savedVar);
        responseWriter.endElement("ul");
    }

    public void renderSuggestionsAsTable(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent, Iterable items) throws IOException {
        AbstractAutocomplete component = (AbstractAutocomplete)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("table", (UIComponent)component);
        String value = AutocompleteRenderer.convertToString(clientId) + "Suggestions";
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.writeAttribute("style", (Object)"display: none", null);
        responseWriter.startElement("tbody", (UIComponent)component);
        Object savedVar = this.saveVar(facesContext, component.getVar());
        for (Object item : items) {
            this.setVar(facesContext, component.getVar(), item);
            responseWriter.startElement("tr", (UIComponent)component);
            Object value2 = component.getFetchValue();
            if (null != value2 && RenderKitUtils.shouldRenderAttribute(value2)) {
                responseWriter.writeAttribute("data-label", value2, null);
            }
            for (UIComponent column : component.getChildren()) {
                responseWriter.startElement("td", (UIComponent)component);
                column.encodeAll(facesContext);
                responseWriter.endElement("td");
            }
            responseWriter.endElement("tr");
        }
        this.setVar(facesContext, component.getVar(), savedVar);
        responseWriter.endElement("tbody");
        responseWriter.endElement("table");
    }

    private static boolean isEqual(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    @Override
    public void renderSuggestions(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractAutocomplete component = (AbstractAutocomplete)uiComponent;
        String clientId = component.getClientId(facesContext);
        if (AutocompleteRenderer.isEqual(component.getLayout(), "list")) {
            this.renderSuggestionsAsList(responseWriter, facesContext, (UIComponent)component, (Iterable)this.getSuggestionsAsDataModel(facesContext, component));
        } else if (AutocompleteRenderer.isEqual(component.getLayout(), "table")) {
            this.renderSuggestionsAsTable(responseWriter, facesContext, (UIComponent)component, (Iterable)this.getSuggestionsAsDataModel(facesContext, component));
        }
    }

    @Override
    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractAutocomplete component = (AbstractAutocomplete)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("div", (UIComponent)component);
        String value = clientId;
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.startElement("input", (UIComponent)component);
        value = this.concatClasses("form-control", component.getAttributes().get("styleClass"));
        if (null != value && RenderKitUtils.shouldRenderAttribute(value)) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (component.isDisabled()) {
            responseWriter.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (null != (value = AutocompleteRenderer.convertToString(clientId) + "Input") && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        if (null != (value = AutocompleteRenderer.convertToString(clientId) + "Input") && value.length() > 0) {
            responseWriter.writeAttribute("name", (Object)value, null);
        }
        responseWriter.writeAttribute("type", (Object)"text", null);
        value = this.getInputValue(facesContext, (UIComponent)component);
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("value", (Object)value, null);
        }
        RenderKitUtils.renderPassThroughAttributes(facesContext, (UIComponent)component, PASS_THROUGH_ATTRIBUTES1);
        responseWriter.endElement("input");
        this.renderSuggestions(responseWriter, facesContext, (UIComponent)component);
        responseWriter.startElement("script", (UIComponent)component);
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, facesContext, (UIComponent)component, ATTRIBUTES_FOR_SCRIPT_HASH1, null);
        RenderKitUtils.addToScriptHash(options, facesContext, (UIComponent)component, ATTRIBUTES_FOR_SCRIPT_HASH2, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        RenderKitUtils.addToScriptHash(options, "filter", this.getClientFilterFunction((UIComponent)component), null, null);
        String text = "RichFaces.jQuery(document.getElementById('" + AutocompleteRenderer.convertToString(clientId) + "')).autocompleteBridge(" + AutocompleteRenderer.convertToString(RenderKitUtils.toScriptArgs(options)) + ");";
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("script");
        responseWriter.endElement("div");
    }
}

