/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.input.autocomplete;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.el.GenericsIntrospectionService;
import org.richfaces.javascript.JSReference;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.CollectionDataModel;
import org.richfaces.services.ServiceTracker;
import org.richfaces.ui.common.meta.MetaComponentRenderer;
import org.richfaces.ui.input.InputRendererBase;
import org.richfaces.ui.input.autocomplete.AbstractAutocomplete;
import org.richfaces.util.InputUtils;

public abstract class AutocompleteRendererBase
extends InputRendererBase
implements MetaComponentRenderer {
    public static final String RENDERER_TYPE = "org.richfaces.ui.AutocompleteRenderer";
    private static final Logger LOGGER = RichfacesLogger.RENDERKIT.getLogger();

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected Object saveVar(FacesContext context, String var) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            return requestMap.get(var);
        }
        return null;
    }

    protected void setVar(FacesContext context, String var, Object varObject) {
        if (var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            requestMap.put(var, varObject);
        }
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String searchTerm;
        AbstractAutocomplete autocomplete = (AbstractAutocomplete)component;
        Map requestParameters = context.getExternalContext().getRequestParameterMap();
        PartialViewContext pvc = context.getPartialViewContext();
        if (InputUtils.isDisabled((UIComponent)autocomplete)) {
            return;
        }
        String value = (String)requestParameters.get(component.getClientId(context) + "Input");
        if (value != null) {
            autocomplete.setSubmittedValue(value);
        }
        if ((searchTerm = (String)requestParameters.get(component.getClientId(context) + "SearchTerm")) != null) {
            String suggestionsMetaComponentId = autocomplete.getSuggestionsMetaComponentId(context);
            pvc.getRenderIds().add(suggestionsMetaComponentId);
            context.renderResponse();
        }
    }

    protected DataModel<Object> getSuggestionsAsDataModel(FacesContext facesContext, AbstractAutocomplete component) {
        Object suggestions = this.getSuggestions(facesContext, component);
        return this.asDataModel(suggestions);
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if (!"suggestions".equals(metaComponentId)) {
            throw new IllegalArgumentException(metaComponentId);
        }
        this.encodeSuggestions(context, component);
    }

    private void encodeSuggestions(FacesContext context, UIComponent component) throws IOException {
        ArrayList fetchValues = new ArrayList();
        String clientId = component.getClientId();
        PartialResponseWriter partialWriter = context.getPartialViewContext().getPartialResponseWriter();
        partialWriter.startUpdate(clientId + "Suggestions");
        this.renderSuggestions(context.getResponseWriter(), context, component);
        partialWriter.endUpdate();
        if (!fetchValues.isEmpty()) {
            Map<String, Object> dataMap = ExtendedPartialViewContext.getInstance(context).getResponseComponentDataMap();
            dataMap.put(component.getClientId(context), fetchValues);
        }
    }

    public abstract void renderSuggestions(ResponseWriter var1, FacesContext var2, UIComponent var3) throws IOException;

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    protected Object getSuggestions(FacesContext facesContext, AbstractAutocomplete component) {
        MethodExpression autocompleteMethod = component.getAutocompleteMethod();
        if (autocompleteMethod != null) {
            Map requestParameters = facesContext.getExternalContext().getRequestParameterMap();
            String searchTerm = (String)requestParameters.get(component.getClientId(facesContext) + "SearchTerm");
            try {
                try {
                    return autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{facesContext, component, searchTerm});
                }
                catch (MethodNotFoundException e) {
                    ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
                    autocompleteMethod = expressionFactory.createMethodExpression(facesContext.getELContext(), autocompleteMethod.getExpressionString(), Object.class, new Class[]{String.class});
                    return autocompleteMethod.invoke(facesContext.getELContext(), new Object[]{searchTerm});
                }
            }
            catch (ELException ee) {
                LOGGER.error(ee.getMessage(), ee);
            }
        } else {
            return component.getAutocompleteList();
        }
        return null;
    }

    public DataModel asDataModel(Object suggestions) {
        if (suggestions instanceof Object[]) {
            return new ArrayDataModel((Object[])suggestions);
        }
        if (suggestions instanceof List) {
            return new ListDataModel((List)suggestions);
        }
        if (suggestions instanceof Result) {
            return new ResultDataModel((Result)suggestions);
        }
        if (suggestions instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)suggestions);
        }
        if (suggestions instanceof Collection) {
            return new CollectionDataModel((Collection)suggestions);
        }
        if (suggestions != null) {
            ArrayList temp = new ArrayList();
            Iterator iterator = ((Iterable)suggestions).iterator();
            while (iterator.hasNext()) {
                temp.add(iterator.next());
            }
            return new ListDataModel(temp);
        }
        return new ListDataModel(null);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object val) throws ConverterException {
        String s = (String)val;
        Converter converter = this.getConverterForValue(context, component);
        if (converter != null) {
            return converter.getAsObject(context, component, s);
        }
        return s;
    }

    private Converter getConverterForValue(FacesContext context, UIComponent component) {
        ValueExpression expression;
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && (expression = component.getValueExpression("value")) != null) {
            Class<?> containerClass = ServiceTracker.getService(context, GenericsIntrospectionService.class).getContainerClass(context, expression);
            converter = InputUtils.getConverterForType(context, containerClass);
        }
        return converter;
    }

    public JSReference getClientFilterFunction(UIComponent component) {
        AbstractAutocomplete autocomplete = (AbstractAutocomplete)component;
        String clientFilter = (String)autocomplete.getAttributes().get("clientFilterFunction");
        if (clientFilter == null || clientFilter.isEmpty()) {
            return null;
        }
        return new JSReference(clientFilter);
    }
}

