/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.input.fileUpload;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.model.UploadedFile;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.attribute.AjaxProps;
import org.richfaces.ui.attribute.CoreProps;
import org.richfaces.ui.attribute.EventsKeyProps;
import org.richfaces.ui.attribute.EventsMouseProps;
import org.richfaces.ui.attribute.I18nProps;
import org.richfaces.ui.input.fileUpload.FileUploadEvent;
import org.richfaces.ui.input.fileUpload.FileUploadListener;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractFileUpload
extends UIComponentBase
implements AjaxProps,
CoreProps,
EventsKeyProps,
EventsMouseProps,
I18nProps {
    public static final String COMPONENT_TYPE = "org.richfaces.ui.FileUpload";
    public static final String COMPONENT_FAMILY = "org.richfaces.ui.FileUpload";
    private static final String QUEUED_FILE_UPLOAD_EVENTS_ATTR = "queuedFileUploadEvents";

    @Attribute
    public abstract String getAcceptedTypes();

    @Attribute(defaultValue="-1")
    public abstract Integer getMaxFilesQuantity();

    @Attribute(defaultValue="false")
    public abstract boolean isDisabled();

    @Attribute(defaultValue="false")
    public abstract boolean isNoDuplicate();

    @Attribute(defaultValue="false")
    public abstract boolean isImmediateUpload();

    @Attribute(events={@EventName(value="fileselect")})
    public abstract String getOnfileselect();

    @Attribute(events={@EventName(value="filesubmit")})
    public abstract String getOnfilesubmit();

    @Attribute(events={@EventName(value="typerejected")})
    public abstract String getOntyperejected();

    @Attribute(events={@EventName(value="uploadcomplete")})
    public abstract String getOnuploadcomplete();

    @Attribute(events={@EventName(value="clear")})
    public abstract String getOnclear();

    @Attribute
    public abstract String getAddLabel();

    @Attribute
    public abstract String getUploadLabel();

    @Attribute
    public abstract String getClearAllLabel();

    @Attribute
    public abstract String getDoneLabel();

    @Attribute
    public abstract String getSizeExceededLabel();

    @Attribute
    public abstract String getServerErrorLabel();

    @Attribute
    public abstract String getClearLabel();

    @Attribute
    public abstract String getDeleteLabel();

    @Attribute(defaultValue="210px")
    public abstract String getListHeight();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        FacesContext context = this.getFacesContext();
        Map facets = this.getFacets();
        UIComponent component = (UIComponent)facets.get("progress");
        if (component == null) {
            try {
                component = context.getApplication().createComponent(context, "org.richfaces.ui.ProgressBar", "org.richfaces.ui.ProgressBarRenderer");
            }
            catch (FacesException e) {
                // empty catch block
            }
            if (component != null) {
                component.setId(this.getId() + "_pb");
                facets.put("progress", component);
            }
        }
        if (component != null) {
            String resourcePath = RenderKitUtils.getResourcePath(context, "org.richfaces.dynamic", "fileUploadProgress");
            component.getAttributes().put("resource", resourcePath);
        }
        if (event.getSource() == this && event instanceof PostAddToViewEvent) {
            this.getAttributes().put(QUEUED_FILE_UPLOAD_EVENTS_ATTR, new AtomicInteger(0));
        }
    }

    public void addFileUploadListener(FileUploadListener listener) {
        this.addFacesListener(listener);
    }

    public FileUploadListener[] getFileUploadListeners() {
        return (FileUploadListener[])this.getFacesListeners(FileUploadListener.class);
    }

    public void removeFileUploadListener(FileUploadListener listener) {
        this.removeFacesListener(listener);
    }

    public List<String> getAcceptedTypesList() {
        String acceptedTypes = this.getAcceptedTypes();
        if (acceptedTypes == null || acceptedTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(acceptedTypes.toLowerCase().replaceAll("\\s+", "").split(","));
    }

    public boolean acceptsFile(UploadedFile file) {
        String clientId = this.getClientId();
        int maxFilesQuantity = this.getMaxFilesQuantity();
        List<String> acceptedTypes = this.getAcceptedTypesList();
        if (maxFilesQuantity > 0 && this.queuedFileUploadEvents().get() >= maxFilesQuantity) {
            return false;
        }
        if (clientId.equals(file.getParameterName())) {
            if (acceptedTypes.isEmpty()) {
                return true;
            }
            if (acceptedTypes.contains(file.getFileExtension().toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof FileUploadEvent) {
            this.queuedFileUploadEvents().addAndGet(1);
        }
        super.queueEvent(event);
    }

    private AtomicInteger queuedFileUploadEvents() {
        AtomicInteger i = (AtomicInteger)this.getAttributes().get(QUEUED_FILE_UPLOAD_EVENTS_ATTR);
        return i;
    }
}

