/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.model.DataVisitResult;
import org.richfaces.model.DataVisitor;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.ui.common.ComponentAttribute;
import org.richfaces.ui.iteration.Row;
import org.richfaces.ui.iteration.RowHolderBase;
import org.richfaces.ui.iteration.UIDataTableBase;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib")})
public abstract class AbstractRowsRenderer
extends RendererBase
implements DataVisitor {
    private static final Map<String, ComponentAttribute> ROW_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onclick").setEventNames("rowclick").setComponentAttributeName("onrowclick"), new ComponentAttribute("ondblclick").setEventNames("rowdblclick").setComponentAttributeName("onrowdblclick"), new ComponentAttribute("onmousedown").setEventNames("rowmousedown").setComponentAttributeName("onrowmousedown"), new ComponentAttribute("onmouseup").setEventNames("rowmouseup").setComponentAttributeName("onrowmouseup"), new ComponentAttribute("onmouseover").setEventNames("rowmouseover").setComponentAttributeName("onrowmouseover"), new ComponentAttribute("onmousemove").setEventNames("rowmousemove").setComponentAttributeName("onrowmousemove"), new ComponentAttribute("onmouseout").setEventNames("rowmouseout").setComponentAttributeName("onrowmouseout"), new ComponentAttribute("onkeypress").setEventNames("rowkeypress").setComponentAttributeName("onrowkeypress"), new ComponentAttribute("onkeydown").setEventNames("rowkeydown").setComponentAttributeName("onrowkeydown"), new ComponentAttribute("onkeyup").setEventNames("rowkeyup").setComponentAttributeName("onrowkeyup")));

    public abstract void encodeRow(ResponseWriter var1, FacesContext var2, RowHolderBase var3) throws IOException;

    public abstract RowHolderBase createRowHolder(FacesContext var1, UIComponent var2, Object[] var3);

    @Override
    public DataVisitResult process(FacesContext facesContext, Object rowKey, Object argument) {
        RowHolderBase holder = (RowHolderBase)argument;
        Row row = holder.getRow();
        row.setRowKey(facesContext, rowKey);
        try {
            ResponseWriter writer = facesContext.getResponseWriter();
            holder.resetProcessCell();
            this.encodeRow(writer, facesContext, holder);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        holder.nextRow();
        return DataVisitResult.CONTINUE;
    }

    protected void encodeRows(FacesContext facesContext, RowHolderBase rowHolder) {
        rowHolder.getRow().walk(facesContext, this, rowHolder);
    }

    public void encodeFakeRow(FacesContext facesContext, RowHolderBase rowHolder) throws IOException {
    }

    protected void renderRowHandlers(FacesContext context, UIDataTableBase dataTable) throws IOException {
        RenderKitUtils.renderPassThroughAttributesOptimized(context, (UIComponent)dataTable, ROW_HANDLER_ATTRIBUTES);
    }

    public void processRows(ResponseWriter writer, FacesContext facesContext, UIComponent component, Object[] options) throws IOException {
        RowHolderBase rowHolder = this.createRowHolder(facesContext, component, options);
        this.encodeRows(facesContext, rowHolder);
        if (!rowHolder.hasWalkedOverRows()) {
            try {
                this.encodeFakeRow(facesContext, rowHolder);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            this.doCleanup(facesContext, rowHolder);
        }
    }

    protected void doCleanup(FacesContext context, RowHolderBase rowHolder) throws IOException {
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext facesContext, UIComponent component) throws IOException {
        this.processRows(writer, facesContext, component, null);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String get(FacesContext context, String key) {
        return (String)context.getAttributes().get(key);
    }

    protected void put(FacesContext context, String key, String value) {
        context.getAttributes().put(key, value);
    }

    protected String[] getRowClasses(RowHolderBase rowHolder) {
        String classes;
        String[] rowClasses = new String[]{};
        if (rowHolder.getRow() instanceof UIDataTableBase && null != (classes = ((UIDataTableBase)rowHolder.getRow()).getRowClasses())) {
            rowClasses = classes.split(",");
        }
        return rowClasses;
    }

    protected String[] getColumnClasses(RowHolderBase rowHolder) {
        String classes;
        String[] columnClasses = new String[]{};
        if (rowHolder.getRow() instanceof UIDataTableBase && null != (classes = ((UIDataTableBase)rowHolder.getRow()).getColumnClasses())) {
            columnClasses = classes.split(",");
        }
        return columnClasses;
    }

    protected String getColumnClass(RowHolderBase rowHolder, int columnNumber) {
        String styleClass = "";
        String[] columnClasses = this.getColumnClasses(rowHolder);
        if (columnClasses.length > columnNumber) {
            styleClass = columnClasses[columnNumber];
        }
        return styleClass;
    }

    protected String getRowClassAttribute(RowHolderBase rowHolder) {
        String rowClass = "";
        if (rowHolder.getRow() instanceof UIDataTableBase) {
            rowClass = ((UIDataTableBase)rowHolder.getRow()).getRowClass();
        }
        return rowClass;
    }

    protected String getRowClass(RowHolderBase rowHolder) {
        String styleClass = "";
        String[] rowClasses = this.getRowClasses(rowHolder);
        if (rowClasses.length > 0) {
            int styleIndex = rowHolder.getCurrentRow() % rowClasses.length;
            styleClass = rowClasses[styleIndex];
        }
        return this.concatClasses(this.getRowClassAttribute(rowHolder), styleClass);
    }
}

