/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.richfaces.model.DataComponentState;
import org.richfaces.model.ExtendedDataModel;
import org.richfaces.ui.iteration.UIDataAdaptor;

public final class DataAdaptorIterationState
implements StateHolder {
    private DataComponentState componentState;
    private Object savedComponentState;
    private boolean componentStateIsStateHolder;
    private ExtendedDataModel<?> dataModel;

    public DataAdaptorIterationState() {
    }

    public DataAdaptorIterationState(DataComponentState componentState, ExtendedDataModel<?> dataModel) {
        this.componentState = componentState;
        this.dataModel = dataModel;
    }

    public ExtendedDataModel<?> getDataModel() {
        return this.dataModel;
    }

    public DataComponentState getComponentState() {
        return this.componentState;
    }

    public void restoreComponentState(UIDataAdaptor uiDataAdaptor) {
        if (this.savedComponentState != null && this.componentStateIsStateHolder) {
            this.componentState = uiDataAdaptor.createComponentState();
            ((StateHolder)this.componentState).restoreState(FacesContext.getCurrentInstance(), this.savedComponentState);
            this.savedComponentState = null;
        }
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    public boolean isTransient() {
        if (this.componentState instanceof StateHolder) {
            return ((StateHolder)this.componentState).isTransient();
        }
        return !(this.componentState instanceof Serializable);
    }

    public Object saveState(FacesContext context) {
        if (this.isTransient()) {
            return null;
        }
        boolean localComponentStateIsHolder = false;
        Object localSavedComponentState = null;
        if (this.componentState instanceof StateHolder) {
            localComponentStateIsHolder = true;
            StateHolder stateHolder = (StateHolder)this.componentState;
            localSavedComponentState = stateHolder.saveState(context);
        } else if (this.componentState instanceof Serializable) {
            localSavedComponentState = this.componentState;
        }
        return new Object[]{localComponentStateIsHolder ? Boolean.TRUE : Boolean.FALSE, localSavedComponentState};
    }

    public void restoreState(FacesContext context, Object stateObject) {
        if (stateObject != null) {
            Object[] state = (Object[])stateObject;
            this.componentStateIsStateHolder = Boolean.TRUE.equals(state[0]);
            Object localSavedComponentState = state[1];
            if (this.componentStateIsStateHolder) {
                this.savedComponentState = localSavedComponentState;
            } else {
                this.componentState = (DataComponentState)localSavedComponentState;
            }
        }
    }
}

