/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.column;

import java.util.Comparator;
import javax.el.ValueExpression;
import javax.faces.component.UIColumn;
import javax.faces.context.FacesContext;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.configuration.ConfigurationServiceHelper;
import org.richfaces.configuration.CoreConfiguration;
import org.richfaces.model.Filter;
import org.richfaces.model.FilterField;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;
import org.richfaces.ui.iteration.column.Column;

public abstract class AbstractColumn
extends UIColumn
implements Column {
    public static final String COMPONENT_TYPE = "org.richfaces.ui.Column";
    public static final String COMPONENT_FAMILY = "org.richfaces.ui.Column";
    private static Boolean builtInSortControlsEnabled;
    private static Boolean builtInFilterControlsEnabled;

    @Attribute
    public abstract boolean isBreakRowBefore();

    @Attribute
    public abstract SortOrder getSortOrder();

    @Attribute
    public abstract Filter<?> getFilter();

    @Attribute
    public abstract Object getFilterValue();

    @Attribute(defaultValue="string")
    public abstract String getFilterType();

    @Attribute
    public abstract String getFilterConverterMessage();

    @Attribute(hidden=true)
    public abstract String getSubmittedFilterValue();

    @Attribute(defaultValue="string")
    public abstract String getSortType();

    @Attribute
    public abstract int getRowspan();

    @Attribute
    public abstract int getColspan();

    @Attribute
    public abstract Comparator<?> getComparator();

    @Attribute
    public abstract Object getFilterExpression();

    @Attribute
    public abstract Object getSortBy();

    @Attribute
    public abstract String getFooterClass();

    @Attribute
    public abstract String getHeaderClass();

    @Attribute
    public abstract String getWidth();

    @Attribute
    public abstract String getStyle();

    @Attribute
    public abstract String getStyleClass();

    public FilterField getFilterField() {
        FilterField field = null;
        Filter<?> filter = this.getFilter();
        ValueExpression filterExpression = this.getValueExpression("filterExpression");
        if (filter != null || filterExpression != null) {
            field = new FilterField(filterExpression, filter, this.getFilterValue());
        }
        return field;
    }

    public SortField getSortField() {
        SortField field = null;
        SortOrder sortOrder = this.getSortOrder();
        if (sortOrder != null && !SortOrder.unsorted.equals((Object)sortOrder)) {
            Comparator<?> comparator = this.getComparator();
            ValueExpression sortBy = this.getValueExpression("sortBy");
            if (comparator != null || sortBy != null) {
                field = new SortField(sortBy, comparator, sortOrder);
            }
        }
        return field;
    }

    public boolean useBuiltInFilter() {
        return AbstractColumn.isBuiltInFilterControlsEnabled() && this.getFilterField() != null && !"custom".equals(this.getFilterType());
    }

    public boolean useBuiltInSort() {
        return AbstractColumn.isBuiltInSortControlsEnabled() && this.getValueExpression("sortBy") != null && !"custom".equals(this.getSortType());
    }

    public static boolean isBuiltInSortControlsEnabled() {
        if (builtInSortControlsEnabled == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            builtInSortControlsEnabled = ConfigurationServiceHelper.getBooleanConfigurationValue(context, CoreConfiguration.Items.builtInSortControlsEnabled);
        }
        return Boolean.TRUE.equals(builtInSortControlsEnabled);
    }

    public static boolean isBuiltInFilterControlsEnabled() {
        if (builtInFilterControlsEnabled == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            builtInFilterControlsEnabled = ConfigurationServiceHelper.getBooleanConfigurationValue(context, CoreConfiguration.Items.builtInFilterControlsEnabled);
        }
        return Boolean.TRUE.equals(builtInFilterControlsEnabled);
    }
}

