/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.extendedDataTable;

import java.io.Serializable;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.json.JSONObject;
import org.richfaces.json.JSONStringer;
import org.richfaces.json.JSONWriter;
import org.richfaces.ui.iteration.UIDataTableBase;
import org.richfaces.ui.iteration.column.AbstractColumn;

abstract class ColumnsState
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected JSONObject json;

    abstract String getValueFromColumn(AbstractColumn var1);

    ColumnsState(UIDataTableBase extendedDataTable) {
        try {
            JSONWriter writer = new JSONStringer().object();
            Iterator<UIComponent> iterator = extendedDataTable.columns();
            while (iterator.hasNext()) {
                UIComponent component = iterator.next();
                AbstractColumn column = (AbstractColumn)component;
                writer.key(column.getId()).value(this.getValueFromColumn(column));
            }
            this.json = new JSONObject(writer.endObject().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    ColumnsState(JSONMap json) {
        if (json != null && json.size() > 0) {
            this.json = new JSONObject(json);
        }
    }

    public String getColumnState(UIComponent column) {
        String state = null;
        if (this.json != null && !this.json.isNull(column.getId())) {
            state = (String)this.json.opt(column.getId());
        }
        return state;
    }

    public boolean isEmpty() {
        return this.json == null || this.json.length() == 0;
    }

    public JSONMap toJSON() {
        return new JSONMap(this.json);
    }

    public String toString() {
        if (this.json == null) {
            return "";
        }
        return this.json.toString();
    }
}

