/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.list;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.ui.attribute.CoreProps;
import org.richfaces.ui.attribute.EventsKeyProps;
import org.richfaces.ui.attribute.EventsMouseProps;
import org.richfaces.ui.attribute.EventsRowProps;
import org.richfaces.ui.attribute.I18nProps;
import org.richfaces.ui.attribute.IterationProps;
import org.richfaces.ui.attribute.RowsProps;
import org.richfaces.ui.attribute.SequenceProps;
import org.richfaces.ui.iteration.UISequence;
import org.richfaces.ui.iteration.list.ListType;

public abstract class AbstractList
extends UISequence
implements CoreProps,
EventsKeyProps,
EventsMouseProps,
EventsRowProps,
I18nProps,
RowsProps,
SequenceProps,
IterationProps {
    public static final String COMPONENT_TYPE = "org.richfaces.ui.List";
    public static final String COMPONENT_FAMILY = "org.richfaces.ui.List";
    public static final String TERM = "term";
    private static final Predicate<String> TERM_PREDICATE = new Predicate<String>(){

        public boolean apply(String input) {
            return AbstractList.TERM.equals(input);
        }
    };
    private static final Predicate<String> NON_TERM_PREDICATE = Predicates.not(TERM_PREDICATE);

    private Iterator<UIComponent> getFacetsIterator(Predicate<? super String> namePredicate) {
        if (this.getFacetCount() > 0) {
            return Maps.filterKeys((Map)this.getFacets(), namePredicate).values().iterator();
        }
        return Iterators.emptyIterator();
    }

    @Override
    protected Iterator<UIComponent> dataChildren() {
        return Iterators.concat(this.getChildren().iterator(), this.getFacetsIterator(TERM_PREDICATE));
    }

    @Override
    protected Iterator<UIComponent> fixedChildren() {
        return this.getFacetsIterator(NON_TERM_PREDICATE);
    }

    @Attribute(defaultValue="ListType.unordered")
    public abstract ListType getType();

    public UIComponent getTerm() {
        return this.getFacet(TERM);
    }

    @Override
    @Attribute(events={@EventName(value="click")})
    public abstract String getOnclick();

    @Override
    @Attribute(events={@EventName(value="dblclick")})
    public abstract String getOndblclick();

    @Override
    @Attribute(events={@EventName(value="mousedown")})
    public abstract String getOnmousedown();

    @Override
    @Attribute(events={@EventName(value="mouseup")})
    public abstract String getOnmouseup();

    @Override
    @Attribute(events={@EventName(value="mouseover")})
    public abstract String getOnmouseover();

    @Override
    @Attribute(events={@EventName(value="mousemove")})
    public abstract String getOnmousemove();

    @Override
    @Attribute(events={@EventName(value="mouseout")})
    public abstract String getOnmouseout();

    @Override
    @Attribute(events={@EventName(value="keypress")})
    public abstract String getOnkeypress();

    @Override
    @Attribute(events={@EventName(value="keydown")})
    public abstract String getOnkeydown();

    @Override
    @Attribute(events={@EventName(value="keyup")})
    public abstract String getOnkeyup();

    @Override
    @Attribute(events={@EventName(value="rowclick")})
    public abstract String getOnrowclick();

    @Override
    @Attribute(events={@EventName(value="rowdblclick")})
    public abstract String getOnrowdblclick();

    @Override
    @Attribute(events={@EventName(value="rowmousedown")})
    public abstract String getOnrowmousedown();

    @Override
    @Attribute(events={@EventName(value="rowmouseup")})
    public abstract String getOnrowmouseup();

    @Override
    @Attribute(events={@EventName(value="rowmouseover")})
    public abstract String getOnrowmouseover();

    @Override
    @Attribute(events={@EventName(value="rowmousemove")})
    public abstract String getOnrowmousemove();

    @Override
    @Attribute(events={@EventName(value="rowmouseout")})
    public abstract String getOnrowmouseout();

    @Override
    @Attribute(events={@EventName(value="rowkeypress")})
    public abstract String getOnrowkeypress();

    @Override
    @Attribute(events={@EventName(value="rowkeydown")})
    public abstract String getOnrowkeydown();

    @Override
    @Attribute(events={@EventName(value="rowkeyup")})
    public abstract String getOnrowkeyup();

    @Override
    @Attribute
    public abstract String getStyle();

    @Override
    @Attribute
    public abstract String getStyleClass();

    @Override
    @Attribute
    public abstract String getTitle();

    @Override
    @Attribute
    public abstract String getDir();

    @Override
    @Attribute
    public abstract String getLang();

    @Attribute
    public abstract String getRowClasses();

    @Attribute
    public abstract String getRowClass();
}

