/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.ui.common.SwitchType;
import org.richfaces.ui.common.meta.MetaComponentRenderer;
import org.richfaces.ui.iteration.tree.AbstractTree;
import org.richfaces.ui.iteration.tree.AbstractTreeNode;
import org.richfaces.ui.iteration.tree.TreeEncoderPartial;
import org.richfaces.ui.iteration.tree.TreeNodeState;
import org.richfaces.ui.iteration.tree.TreeRendererBase;
import org.richfaces.ui.iteration.tree.TreeRenderingContext;
import org.richfaces.ui.iteration.tree.TreeToggleEvent;

public class TreeNodeRendererBase
extends RendererBase
implements MetaComponentRenderer {
    static final String AJAX_TOGGLED_NODE_ATTRIBUTE = TreeNodeRendererBase.class.getName() + ":AJAX_TOGGLED_NODE_ATTRIBUTE";
    static final String AJAX_TOGGLED_NODE_STATE_ATTRIBUTE = TreeNodeRendererBase.class.getName() + ":AJAX_TOGGLED_NODE_STATE_ATTRIBUTE";
    private static final String NEW_NODE_TOGGLE_STATE = "__NEW_NODE_TOGGLE_STATE";
    private static final String TRIGGER_NODE_AJAX_UPDATE = "__TRIGGER_NODE_AJAX_UPDATE";
    private static final String HANDLE_LOADING_FACET_NAME = "handleLoading";

    @Override
    public void doDecode(FacesContext context, UIComponent component) {
        Map map = context.getExternalContext().getRequestParameterMap();
        String newToggleState = (String)map.get(component.getClientId(context) + NEW_NODE_TOGGLE_STATE);
        if (newToggleState != null) {
            PartialViewContext pvc;
            boolean newState;
            AbstractTreeNode treeNode = (AbstractTreeNode)component;
            boolean initialState = treeNode.isExpanded();
            if (initialState ^ (newState = Boolean.valueOf(newToggleState).booleanValue())) {
                new TreeToggleEvent((UIComponent)treeNode, newState).queue();
            }
            if ((pvc = context.getPartialViewContext()).isAjaxRequest() && map.get(component.getClientId(context) + TRIGGER_NODE_AJAX_UPDATE) != null) {
                pvc.getRenderIds().add(component.getClientId(context) + '@' + "subtree");
                context.getAttributes().put(AJAX_TOGGLED_NODE_ATTRIBUTE, component.getClientId(context));
                context.getAttributes().put(AJAX_TOGGLED_NODE_STATE_ATTRIBUTE, initialState ? TreeNodeState.expanded : TreeNodeState.collapsed);
            }
        }
    }

    @Override
    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        if (!"subtree".equals(metaComponentId)) {
            throw new IllegalArgumentException(metaComponentId);
        }
        AbstractTreeNode treeNode = (AbstractTreeNode)component;
        new TreeEncoderPartial(context, treeNode).encode();
    }

    protected TreeNodeState getNodeState(FacesContext context) {
        return (TreeNodeState)((Object)context.getAttributes().get("__treeNodeState"));
    }

    protected UIComponent getTreeComponent(UIComponent treeNodeComponent) {
        return ((AbstractTreeNode)treeNodeComponent).findTreeComponent();
    }

    protected void encodeDefaultIcon(FacesContext context, UIComponent component, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.endElement("span");
    }

    protected void encodeCustomIcon(FacesContext context, UIComponent component, String styleClass, String iconSource) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", component);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeURIAttribute("src", (Object)RenderKitUtils.getResourceURL(iconSource, context), null);
        writer.endElement("img");
    }

    protected void encodeIcon(FacesContext context, UIComponent component) throws IOException {
        TreeNodeState nodeState = this.getNodeState(context);
        AbstractTreeNode treeNode = (AbstractTreeNode)component;
        AbstractTree tree = treeNode.findTreeComponent();
        if (nodeState.isLeaf()) {
            String iconLeaf = (String)RenderKitUtils.getFirstNonEmptyAttribute("iconLeaf", (UIComponent)treeNode, (UIComponent)tree);
            this.encodeIconForNodeState(context, tree, treeNode, nodeState, iconLeaf);
        } else {
            String iconExpanded = (String)RenderKitUtils.getFirstNonEmptyAttribute("iconExpanded", (UIComponent)treeNode, (UIComponent)tree);
            String iconCollapsed = (String)RenderKitUtils.getFirstNonEmptyAttribute("iconCollapsed", (UIComponent)treeNode, (UIComponent)tree);
            if (Strings.isNullOrEmpty((String)iconCollapsed) && Strings.isNullOrEmpty((String)iconExpanded)) {
                this.encodeIconForNodeState(context, tree, treeNode, nodeState, null);
            } else {
                SwitchType toggleType = TreeRendererBase.getToggleTypeOrDefault(treeNode.findTreeComponent());
                if (toggleType == SwitchType.client || nodeState == TreeNodeState.collapsed) {
                    this.encodeIconForNodeState(context, tree, treeNode, TreeNodeState.collapsed, iconCollapsed);
                }
                if (toggleType == SwitchType.client || nodeState == TreeNodeState.expanded || nodeState == TreeNodeState.expandedNoChildren) {
                    this.encodeIconForNodeState(context, tree, treeNode, TreeNodeState.expanded, iconExpanded);
                }
            }
        }
    }

    protected void encodeIconForNodeState(FacesContext context, AbstractTree tree, AbstractTreeNode treeNode, TreeNodeState nodeState, String customIcon) throws IOException {
        if (Strings.isNullOrEmpty((String)customIcon)) {
            this.encodeDefaultIcon(context, (UIComponent)treeNode, this.concatClasses(nodeState.getIconClass(), treeNode.getAttributes().get("iconClass"), tree.getAttributes().get("iconClass")));
        } else {
            this.encodeCustomIcon(context, (UIComponent)treeNode, this.concatClasses(nodeState.getCustomIconClass(), treeNode.getAttributes().get("iconClass"), tree.getAttributes().get("iconClass")), customIcon);
        }
    }

    protected void addClientEventHandlers(FacesContext facesContext, UIComponent component) {
        AbstractTreeNode treeNode = (AbstractTreeNode)component;
        TreeRenderingContext renderingContext = TreeRenderingContext.get(facesContext);
        renderingContext.addHandlers(treeNode);
    }

    protected UIComponent getHandleLoadingFacetIfApplicable(UIComponent component) {
        AbstractTreeNode treeNode = (AbstractTreeNode)component;
        AbstractTree tree = treeNode.findTreeComponent();
        if (TreeRendererBase.getToggleTypeOrDefault(tree) != SwitchType.ajax) {
            return null;
        }
        UIComponent facet = treeNode.getFacet(HANDLE_LOADING_FACET_NAME);
        if (facet == null) {
            facet = tree.getFacet(HANDLE_LOADING_FACET_NAME);
        }
        if (facet != null && facet.isRendered()) {
            return facet;
        }
        return null;
    }
}

