/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree.convert;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.richfaces.model.DeclarativeModelKey;
import org.richfaces.model.SequenceRowKey;
import org.richfaces.ui.iteration.tree.AbstractTree;
import org.richfaces.ui.iteration.tree.convert.SequenceRowKeyConverter;
import org.richfaces.ui.iteration.tree.convert.TreeConverterUtil;

public class DeclarativeModelSequenceKeyConverter
implements Converter {
    public static final String CONVERTER_ID = "org.richfaces.ui.DeclarativeModelSequenceKeyConverter";

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        Iterator split = SequenceRowKeyConverter.SEPARATOR_SPLITTER.split((CharSequence)value).iterator();
        AbstractTree tree = (AbstractTree)component;
        ArrayList declarativeKeys = Lists.newArrayList();
        while (split.hasNext()) {
            String modelId = TreeConverterUtil.unescape((String)split.next());
            String modelKeyAsString = TreeConverterUtil.unescape((String)split.next());
            DeclarativeModelKey declarativeKey = tree.convertDeclarativeKeyFromString(context, modelId, modelKeyAsString);
            declarativeKeys.add(declarativeKey);
        }
        return new SequenceRowKey(declarativeKeys.toArray(new DeclarativeModelKey[declarativeKeys.size()]));
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        SequenceRowKey sequenceRowKey = (SequenceRowKey)value;
        Object[] declarativeKeys = sequenceRowKey.getSimpleKeys();
        AbstractTree tree = (AbstractTree)component;
        StringBuilder result = new StringBuilder();
        for (Object declarativeKeyObject : declarativeKeys) {
            DeclarativeModelKey declarativeKey = (DeclarativeModelKey)declarativeKeyObject;
            String modelId = TreeConverterUtil.escape(declarativeKey.getModelId());
            String modelKeyAsString = TreeConverterUtil.escape(tree.convertDeclarativeKeyToString(context, declarativeKey));
            if (result.length() != 0) {
                result.append('.');
            }
            result.append(modelId);
            result.append('.');
            result.append(modelKeyAsString);
        }
        return result.toString();
    }
}

