/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree.model;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import javax.faces.convert.Converter;
import javax.swing.tree.TreeNode;
import org.richfaces.model.TreeDataModelTuple;
import org.richfaces.ui.iteration.tree.convert.IntegerSequenceRowKeyConverter;
import org.richfaces.ui.iteration.tree.model.IterableDataTuplesIterator;
import org.richfaces.ui.iteration.tree.model.NodesTreeSequenceKeyModel;
import org.richfaces.ui.iteration.tree.model.SwingTreeNodeImpl;

public class SwingTreeNodeDataModelImpl
extends NodesTreeSequenceKeyModel<TreeNode> {
    private static final Converter DEFAULT_CONVERTER = new IntegerSequenceRowKeyConverter();
    private boolean asksAllowsChildren = false;
    private Object wrappedData;

    private TreeNode createFakeRootNode(Object wrappedData) {
        Collection nodes;
        if (wrappedData instanceof Collection) {
            nodes = (Collection)wrappedData;
        } else if (wrappedData instanceof TreeNode) {
            nodes = Lists.newArrayList((Object[])new TreeNode[]{(TreeNode)wrappedData});
        } else if (wrappedData == null) {
            nodes = null;
        } else {
            throw new IllegalArgumentException(String.valueOf(wrappedData));
        }
        SwingTreeNodeImpl treeNodeImpl = new SwingTreeNodeImpl(nodes);
        treeNodeImpl.setAllowUpdateParents(false);
        return treeNodeImpl;
    }

    @Override
    public void setWrappedData(Object data) {
        this.wrappedData = data;
        this.setRootNode(this.createFakeRootNode(data));
    }

    @Override
    public Object getWrappedData() {
        return this.wrappedData;
    }

    protected TreeNode findChild(TreeNode parent, Integer simpleKey) {
        int childIdx = simpleKey;
        if (childIdx < parent.getChildCount()) {
            return parent.getChildAt(childIdx);
        }
        return null;
    }

    @Override
    public Iterator<TreeDataModelTuple> children() {
        UnmodifiableIterator children = Iterators.forEnumeration(((TreeNode)this.getData()).children());
        return new IterableDataTuplesIterator(this.getRowKey(), (Iterator<?>)children);
    }

    @Override
    public boolean isLeaf() {
        if (!this.asksAllowsChildren) {
            return ((TreeNode)this.getData()).isLeaf();
        }
        return !((TreeNode)this.getData()).getAllowsChildren();
    }

    @Override
    protected TreeNode setupChildContext(Object segment) {
        return this.findChild((TreeNode)this.getData(), (Integer)segment);
    }

    @Override
    public Converter getRowKeyConverter() {
        return DEFAULT_CONVERTER;
    }
}

