/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.iteration.tree.model;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;

public class SwingTreeNodeImpl<T>
implements TreeNode,
Serializable {
    private static final long serialVersionUID = 8841984268370598781L;
    private TreeNode parent;
    private T data;
    private Collection<TreeNode> children;
    private boolean allowUpdateParents = true;

    public SwingTreeNodeImpl() {
        this(null);
    }

    public SwingTreeNodeImpl(Collection<TreeNode> children) {
        this.children = SwingTreeNodeImpl.wrapNull(children);
    }

    void setAllowUpdateParents(boolean allowUpdateParents) {
        this.allowUpdateParents = allowUpdateParents;
    }

    private static Collection<TreeNode> wrapNull(Collection<TreeNode> src) {
        return src != null ? src : Lists.newArrayList();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (childIndex < this.getChildCount()) {
            return (TreeNode)Iterables.get(this.children, (int)childIndex);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return Iterables.indexOf(this.children, (Predicate)Predicates.equalTo((Object)node));
    }

    public void addChild(TreeNode node) {
        this.children.add(node);
        if (this.allowUpdateParents && node instanceof SwingTreeNodeImpl) {
            SwingTreeNodeImpl treeNodeImpl = (SwingTreeNodeImpl)node;
            treeNodeImpl.setParent(this);
        }
    }

    public void removeChild(TreeNode node) {
        if (this.children.remove(node) && this.allowUpdateParents && node instanceof SwingTreeNodeImpl) {
            SwingTreeNodeImpl treeNodeImpl = (SwingTreeNodeImpl)node;
            treeNodeImpl.setParent(null);
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration<?> children() {
        return Iterators.asEnumeration(this.children.iterator());
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Collection<TreeNode> getChildrenList() {
        return this.children;
    }

    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this);
        toStringHelper.add("data", this.data);
        return toStringHelper.toString();
    }
}

