/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.menu.menu;

import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.richfaces.ui.ajax.command.AjaxCommandRendererBase;
import org.richfaces.ui.behavior.HandlersChain;
import org.richfaces.ui.common.Mode;
import org.richfaces.ui.menu.menu.AbstractMenuContainer;
import org.richfaces.ui.menu.menu.AbstractMenuGroup;
import org.richfaces.ui.menu.menu.AbstractMenuItem;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="menu/dropDownMenu/dropdownmenu.ecss", target="head")})
public class MenuItemRendererBase
extends AjaxCommandRendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.ui.MenuItemRenderer";

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof AbstractMenuItem) {
            return ((AbstractMenuItem)component).isDisabled();
        }
        return false;
    }

    protected UIComponent getIconFacet(FacesContext facesContext, UIComponent component) {
        UIComponent facet = null;
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        if (menuItem != null) {
            facet = menuItem.isDisabled() ? menuItem.getFacet(AbstractMenuItem.Facets.iconDisabled.toString()) : menuItem.getFacet(AbstractMenuItem.Facets.icon.toString());
        }
        return facet;
    }

    protected String getIconAttribute(FacesContext facesContext, UIComponent component) {
        String icon = null;
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        if (menuItem != null) {
            icon = menuItem.isDisabled() ? menuItem.getIconDisabled() : menuItem.getIcon();
        }
        return icon;
    }

    @Override
    public void doDecode(FacesContext context, UIComponent component) {
        Mode mode;
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        if (menuItem != null && !Mode.client.equals((Object)(mode = this.resolveSubmitMode(menuItem)))) {
            super.doDecode(context, component);
        }
    }

    private UIComponent getUIForm(UIComponent component) {
        if (component != null) {
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof UIForm)) continue;
                return parent;
            }
        }
        return null;
    }

    @Override
    public String getOnClick(FacesContext context, UIComponent component) {
        AbstractMenuItem menuItem = (AbstractMenuItem)component;
        Mode submitMode = this.resolveSubmitMode(menuItem);
        StringBuffer onClick = new StringBuffer();
        if (!this.getUtils().isBooleanAttribute(component, "disabled")) {
            HandlersChain handlersChain = new HandlersChain(context, component);
            handlersChain.addInlineHandlerFromAttribute("onclick");
            handlersChain.addBehaviors("click", "action");
            switch (submitMode) {
                case ajax: {
                    handlersChain.addAjaxSubmitFunction();
                    break;
                }
                case server: {
                    handlersChain.addInlineHandlerAsValue("RichFaces.submitForm(event.form, event.itemId)");
                }
            }
            String handlerScript = handlersChain.toScript();
            if (handlerScript != null) {
                onClick.append(handlerScript);
            }
            if (!"reset".equals(component.getAttributes().get("type"))) {
                onClick.append(";return false;");
            }
        } else {
            onClick.append("return false;");
        }
        return onClick.toString();
    }

    protected Mode resolveSubmitMode(AbstractMenuItem menuItem) {
        if (menuItem.getMode() != null) {
            return menuItem.getMode();
        }
        AbstractMenuContainer parent = this.getMenuParent((UIComponent)menuItem);
        if (parent != null && parent.getMode() != null) {
            return parent.getMode();
        }
        return Mode.server;
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent component, String menuParentStyle, String menuGroupStyle, String menuItemStyle) {
        AbstractMenuContainer parent = this.getMenuParent(component);
        AbstractMenuGroup menuGroup = this.getMenuGroup(component);
        String styleClass = null;
        if (parent != null && menuParentStyle != null && menuParentStyle.length() > 0) {
            styleClass = (String)parent.getAttributes().get(menuParentStyle);
        }
        if (menuGroup != null && menuGroupStyle != null && menuGroupStyle.length() > 0) {
            styleClass = this.concatClasses(styleClass, menuGroup.getAttributes().get(menuGroupStyle));
        }
        return this.concatClasses(styleClass, component.getAttributes().get(menuItemStyle));
    }

    private UIComponent getParent(UIComponent component, Class<?> parentClass) {
        if (component != null && parentClass != null) {
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!parentClass.isInstance(parent)) continue;
                return parent;
            }
        }
        return null;
    }

    protected AbstractMenuContainer getMenuParent(UIComponent component) {
        return (AbstractMenuContainer)this.getParent(component, AbstractMenuContainer.class);
    }

    protected AbstractMenuGroup getMenuGroup(UIComponent component) {
        return (AbstractMenuGroup)this.getParent(component, AbstractMenuGroup.class);
    }

    protected boolean isStringEmpty(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public String getSubmitMode(UIComponent component) {
        return this.resolveSubmitMode((AbstractMenuItem)component).name();
    }
}

