/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.ui.message.NotifyAttributes;
import org.richfaces.ui.message.notify.AbstractNotify;
import org.richfaces.ui.message.notifyStack.AbstractNotifyStack;
import org.richfaces.util.HtmlUtil;
import org.richfaces.util.RendererUtils;

public class NotifyRendererUtils {
    private static final RendererUtils UTILS = RendererUtils.getInstance();

    public static String getStackId(FacesContext facesContext, UIComponent component) {
        NotifyAttributes notify = (NotifyAttributes)component;
        if (null == notify.getStack()) {
            return null;
        }
        UIComponent stack = UTILS.findComponentFor((UIComponent)facesContext.getViewRoot(), notify.getStack());
        if (stack instanceof AbstractNotifyStack) {
            return stack.getClientId();
        }
        return null;
    }

    public static void addStackIdOption(Map<String, Object> options, FacesContext facesContext, UIComponent component) {
        String stackId = NotifyRendererUtils.getStackId(facesContext, component);
        if (stackId != null) {
            options.put("stackId", stackId);
        }
    }

    public static void addFacetOrAttributeAsOption(String name, Map<String, Object> options, FacesContext facesContext, UIComponent component) {
        UIComponent facet = component.getFacet(name);
        if (facet != null && facet.isRendered()) {
            ResponseWriter originalResponseWriter = facesContext.getResponseWriter();
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                PrintWriter printWriter = new PrintWriter(outputStream);
                ResponseWriter newResponseWriter = facesContext.getRenderKit().createResponseWriter((Writer)printWriter, null, null);
                facesContext.setResponseWriter(newResponseWriter);
                facet.encodeAll(facesContext);
                printWriter.flush();
                String value = new String(outputStream.toByteArray());
                options.put(name, value);
            }
            catch (IOException e) {
                throw new FacesException("Can't encode facet '" + name + "' of component '" + component.getClass().getName() + "'", (Throwable)e);
            }
            finally {
                facesContext.setResponseWriter(originalResponseWriter);
            }
            return;
        }
        Object attribute = component.getAttributes().get(name);
        if (attribute != null) {
            String value = attribute.toString();
            boolean escape = true;
            if (component instanceof AbstractNotify) {
                escape = ((AbstractNotify)component).isEscape();
            }
            if (escape) {
                value = HtmlUtil.escapeHtml(value);
            }
            options.put(name, value);
            return;
        }
    }
}

