/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.misc.componentControl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import org.richfaces.javascript.JSFunction;
import org.richfaces.javascript.JSFunctionDefinition;
import org.richfaces.javascript.JSReference;
import org.richfaces.javascript.ScriptUtils;
import org.richfaces.ui.misc.componentControl.ComponentControlBehavior;
import org.richfaces.ui.misc.hashParameter.UIHashParameter;
import org.richfaces.util.RendererUtils;

@FacesBehaviorRenderer(rendererType="org.richfaces.ui.behavior.ComponentControlBehaviorRenderer", renderKitId="HTML_BASIC")
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="common/richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="misc/componentControl/component-control.js")})
public class ComponentControlBehaviorRenderer
extends ClientBehaviorRenderer {
    public static final String RENDERER_TYPE = "org.richfaces.ui.behavior.ComponentControlBehaviorRenderer";
    private static final RendererUtils RENDERER_UTILS = RendererUtils.getInstance();
    private static final String FUNC_NAME = "RichFaces.ui.ComponentControl.execute";
    private static final String REF_EVENT = "event";
    private static final String REF_COMPONENT = "component";
    private static final String PARAM_CALLBACK = "callback";
    private static final String PARAM_TARGET = "target";
    private static final String PARAM_SELECTOR = "selector";
    private static final String PARAM_ONBEFOREOPERATION = "onbeforeoperation";
    private static final Pattern COMMA_SEPARATED_STRING = Pattern.compile("\\s*,\\s*");

    private boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        FacesContext facesContext = behaviorContext.getFacesContext();
        ComponentControlBehavior controlBehavior = (ComponentControlBehavior)behavior;
        String apiFunctionName = controlBehavior.getOperation();
        String targetSourceString = controlBehavior.getTarget();
        String selector = controlBehavior.getSelector();
        if (this.isEmpty(apiFunctionName) || this.isEmpty(targetSourceString) && this.isEmpty(selector)) {
            throw new IllegalArgumentException("One of the necessary attributes is null or empty. Check operation attribute and selector or target attributes.");
        }
        JSFunctionDefinition callback = new JSFunctionDefinition(new Object[0]);
        callback.addParameter(new JSReference(REF_EVENT));
        callback.addParameter(new JSReference(REF_COMPONENT));
        StringBuffer script = new StringBuffer();
        script.append(REF_COMPONENT).append("['").append(apiFunctionName).append("'].").append("apply").append("(");
        List<Object> apiFunctionParams = this.createSignature(controlBehavior);
        script.append(REF_COMPONENT).append(",").append(ScriptUtils.toScript(apiFunctionParams.toArray())).append(");");
        callback.addToBody(script);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAM_CALLBACK, callback);
        parameters.put(PARAM_TARGET, this.resolveTargets(facesContext, targetSourceString));
        parameters.put(PARAM_SELECTOR, selector);
        String onBeforeOperation = controlBehavior.getOnbeforeoperation();
        if (null != onBeforeOperation && !onBeforeOperation.isEmpty()) {
            JSFunctionDefinition onBeforeOperationFunction = new JSFunctionDefinition(new JSReference(REF_EVENT));
            onBeforeOperationFunction.addToBody(onBeforeOperation);
            parameters.put(PARAM_ONBEFOREOPERATION, onBeforeOperationFunction);
        }
        JSFunction eventFunction = new JSFunction(FUNC_NAME, new Object[0]);
        eventFunction.addParameter(new JSReference(REF_EVENT));
        eventFunction.addParameter(parameters);
        StringBuffer execution = new StringBuffer();
        execution.append(eventFunction.toScript());
        execution.append("; return false;");
        return execution.toString();
    }

    protected List<Object> createSignature(ComponentControlBehavior behavior) {
        ArrayList<Object> elements = new ArrayList<Object>();
        List<UIComponent> children = behavior.getChildren();
        for (UIComponent child : children) {
            Object parameter;
            if (child instanceof UIParameter) {
                parameter = (UIParameter)child;
                Object value = RendererUtils.getInstance().createParameterValue((UIParameter)parameter);
                if (value != null) {
                    elements.add(value);
                }
            }
            if (!(child instanceof UIHashParameter)) continue;
            parameter = (UIHashParameter)child;
            String name = ((UIHashParameter)((Object)parameter)).getName();
            Map<String, Object> value = RendererUtils.getInstance().createParametersMap(FacesContext.getCurrentInstance(), child);
            if (value == null) continue;
            if (name != null) {
                HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
                map.put(name, value);
                elements.add(map);
                continue;
            }
            elements.add(value);
        }
        return elements;
    }

    protected String[] resolveTargets(FacesContext context, String targetSourceString) {
        if (targetSourceString == null) {
            return null;
        }
        String[] split = COMMA_SEPARATED_STRING.split(targetSourceString);
        UIComponent contextComponent = UIComponent.getCurrentComponent((FacesContext)context);
        if (contextComponent == null) {
            contextComponent = context.getViewRoot();
        }
        ArrayList<String> resultHolder = new ArrayList<String>(split.length);
        for (String target : split) {
            UIComponent targetComponent = RENDERER_UTILS.findComponentFor(contextComponent, target);
            String targetClientId = targetComponent != null ? targetComponent.getClientId(context) : target;
            resultHolder.add(targetClientId);
        }
        return resultHolder.toArray(new String[resultHolder.size()]);
    }
}

