/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.misc.componentControl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import org.richfaces.ui.common.CustomBehaviorHandler;
import org.richfaces.ui.misc.componentControl.ComponentControlBehavior;

public class ComponentControlHandler
extends CustomBehaviorHandler {
    public ComponentControlHandler(BehaviorConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        super.apply(ctx, parent);
        this.processNestedTags(ctx, parent);
    }

    private void processNestedTags(FaceletContext ctx, UIComponent parent) throws IOException {
        if (this.nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] children;
            for (FaceletHandler handler : children = ((CompositeFaceletHandler)this.nextHandler).getHandlers()) {
                this.processNextHandler(ctx, handler, parent);
            }
        } else {
            this.processNextHandler(ctx, this.nextHandler, parent);
        }
    }

    private void processNextHandler(FaceletContext ctx, FaceletHandler handler, UIComponent parent) throws IOException {
        ComponentHandler componentHandler;
        ComponentConfig componentConfig;
        String componentType;
        if (handler instanceof ComponentHandler && this.isUIParameter(componentType = (componentConfig = (componentHandler = (ComponentHandler)handler).getComponentConfig()).getComponentType())) {
            FacesContext facesContext = ctx.getFacesContext();
            UIComponent component = facesContext.getApplication().createComponent(componentType);
            componentHandler.setAttributes(ctx, (Object)component);
            if (parent instanceof ClientBehaviorHolder) {
                ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)parent;
                Map clientBehaviors = clientBehaviorHolder.getClientBehaviors();
                String eventName = this.getEventName();
                if (eventName == null) {
                    eventName = clientBehaviorHolder.getDefaultEventName();
                }
                if (eventName != null) {
                    List eventClientBehaviors = (List)clientBehaviors.get(eventName);
                    for (ClientBehavior clientBehavior : eventClientBehaviors) {
                        if (!(clientBehavior instanceof ComponentControlBehavior)) continue;
                        ((ComponentControlBehavior)clientBehavior).getChildren().add(component);
                    }
                }
            }
            componentHandler.applyNextHandler(ctx, component);
        }
    }

    private boolean isUIParameter(String type) {
        return "javax.faces.Parameter".equals(type) || "org.richfaces.ui.HashParameter".equals(type) || "org.richfaces.ui.Parameter".equals(type);
    }

    @Override
    public boolean isWrapping() {
        return false;
    }
}

