/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.misc.focus;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.misc.focus.AbstractFocus;
import org.richfaces.ui.misc.focus.FocusRendererBase;

public class FocusRenderer
extends FocusRendererBase {
    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    @Override
    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent uiComponent) throws IOException {
        AbstractFocus component = (AbstractFocus)uiComponent;
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("span", (UIComponent)component);
        responseWriter.writeAttribute("class", (Object)"rf-fcs", null);
        Object value = clientId;
        if (null != value && ((String)value).length() > 0) {
            responseWriter.writeAttribute("id", value, null);
        }
        responseWriter.startElement("input", (UIComponent)component);
        value = FocusRenderer.convertToString(clientId) + "InputFocus";
        if (null != value && ((String)value).length() > 0) {
            responseWriter.writeAttribute("id", value, null);
        }
        responseWriter.writeAttribute("name", (Object)"org.richfaces.focus", null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        value = component.getValue();
        if (null != value && RenderKitUtils.shouldRenderAttribute(value)) {
            responseWriter.writeAttribute("value", value, null);
        }
        responseWriter.endElement("input");
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, "mode", (Object)component.getMode(), null, null);
        RenderKitUtils.addToScriptHash(options, "focusCandidates", this.getFocusCandidatesAsString(facesContext, component), null, null);
        String scriptArgs = RenderKitUtils.toScriptArgs(options);
        String script = "new RichFaces.ui.Focus('" + FocusRenderer.convertToString(clientId) + "', " + FocusRenderer.convertToString(FocusRenderer.isEmpty(scriptArgs) ? "{}" : scriptArgs) + ");";
        this.renderOncompleteScript(facesContext, script);
        if (this.shouldApply(facesContext, component)) {
            String applyScript = "RichFaces.component('" + FocusRenderer.convertToString(clientId) + "').applyFocus()";
            this.renderOncompleteScript(facesContext, applyScript);
        }
        responseWriter.endElement("span");
    }
}

