/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.misc.focus;

import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.context.FacesContext;
import org.richfaces.javascript.JSLiteral;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.services.ServiceTracker;
import org.richfaces.ui.misc.focus.AbstractFocus;
import org.richfaces.ui.misc.focus.FocusRenderStrategy;
import org.richfaces.ui.misc.focus.FocusRendererInterface;
import org.richfaces.ui.misc.focus.FormFocusRenderStrategy;
import org.richfaces.ui.misc.focus.ViewFocusRenderStrategy;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="common/richfaces-base-component.js"), @ResourceDependency(library="com.jqueryui", name="jquery.ui.core.js"), @ResourceDependency(library="org.richfaces", name="misc/focus/focus.js")})
public class FocusRendererBase
extends RendererBase
implements FocusRendererInterface {
    public static final String RENDERER_TYPE = "org.richfaces.ui.FocusRenderer";
    private final FormFocusRenderStrategy FORM_RENDERING_STRATEGY = new FormFocusRenderStrategy();
    private final ViewFocusRenderStrategy VIEW_RENDERING_STRATEGY = new ViewFocusRenderStrategy();

    public boolean shouldApply(FacesContext context, AbstractFocus component) {
        return this.getStrategy(component).shouldApply(context, component);
    }

    public String getFocusCandidatesAsString(FacesContext context, AbstractFocus component) {
        return this.getStrategy(component).getFocusCandidatesAsString(context, component);
    }

    @Override
    public void postAddToView(FacesContext context, AbstractFocus component) {
        this.getStrategy(component).postAddToView(context, component);
    }

    public void renderOncompleteScript(FacesContext context, String script) {
        JavaScriptService javaScriptService = ServiceTracker.getService(JavaScriptService.class);
        javaScriptService.addScript(context, new JSLiteral(script));
    }

    private FocusRenderStrategy getStrategy(AbstractFocus component) {
        switch (component.getMode()) {
            case FORM: {
                return this.FORM_RENDERING_STRATEGY;
            }
            case VIEW: {
                return this.VIEW_RENDERING_STRATEGY;
            }
        }
        throw new UnsupportedOperationException("Retrieving focus candidates in " + (Object)((Object)component.getMode()) + " mode is not supported");
    }
}

