/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.ui.misc.jquery;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.ui.misc.jquery.JQueryAttachType;
import org.richfaces.ui.misc.jquery.JQueryRendererBase;
import org.richfaces.ui.misc.jquery.JQueryTiming;

public class JQueryRenderer
extends JQueryRendererBase {
    private static final RenderKitUtils.Attributes ATTRIBUTES_FOR_SCRIPT_HASH34 = RenderKitUtils.attributes().generic("event", "event", new String[0]).generic("query", "query", new String[0]);

    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return object.toString().length() == 0;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("span", component);
        String value = clientId;
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.writeAttribute("style", (Object)"display: none;", null);
        responseWriter.startElement("script", component);
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        Object functionName = component.getAttributes().get("name");
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, "selector", this.getEscapedSelector(facesContext, component), null, null);
        RenderKitUtils.addToScriptHash(options, facesContext, component, ATTRIBUTES_FOR_SCRIPT_HASH34, null);
        RenderKitUtils.addToScriptHash(options, "attachType", component.getAttributes().get("attachType"), (Object)JQueryAttachType.DEFAULT, null);
        RenderKitUtils.addToScriptHash(options, "timing", component.getAttributes().get("timing"), (Object)JQueryTiming.DEFAULT, null);
        if (!JQueryRenderer.isEmpty(functionName)) {
            String text = JQueryRenderer.convertToString(functionName) + " = RichFaces.ui.jQueryComponent.createFunction(" + JQueryRenderer.convertToString(RenderKitUtils.toScriptArgs(options)) + ");";
            if (text != null) {
                responseWriter.writeText((Object)text, null);
            }
        } else {
            String text = "RichFaces.ui.jQueryComponent.query(" + JQueryRenderer.convertToString(RenderKitUtils.toScriptArgs(options)) + ");";
            if (text != null) {
                responseWriter.writeText((Object)text, null);
            }
        }
        responseWriter.endElement("script");
        responseWriter.endElement("span");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

